/*
 *
 * (c) Copyright Ascensio System Limited 2010-2018
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
*/


package cn.gtmap.gtc.document.domain.enums;

/**
 * @author zenglihuan
 * @create 2018/12/6 9:45
 * @discription 文档类型
 * TEXT：文档
 * SPREADSHEET：表格
 * PRESENTATION：幻灯片
 **/
public enum DocumentType
{
    TEXT("text"),
    SPREADSHEET("spreadsheet"),
    PRESENTATION("presentation");

    String value;

    DocumentType(String value) {
        this.value = value;
    }

    public static DocumentType enumOfValue(String value){
        switch (value){
            case "text": return DocumentType.TEXT;
            case "spreadsheet": return DocumentType.SPREADSHEET;
            case "presentation": return DocumentType.PRESENTATION;
            default: return DocumentType.TEXT;
        }
    }

    public String value(){
        return this.value;
    }
}