package cn.gtmap.gtc.document.domain.enums;

import org.springframework.util.StringUtils;

/**
 * @author zenglihuan
 * @create 2018/12/6 9:11
 * @discription 预览/编辑权限
 * PUBLIC：公开，任何用户都可以预览
 * PRIVATE：隐私，只有创建人可以预览
 **/
public enum Authority {

    PUBLIC("public"),
    PRIVATE("private");

    String value;

    Authority(String value) {
        this.value = value;
    }

    public static Authority enumOfValue(String value){
        if(StringUtils.isEmpty(value)){
            return Authority.PRIVATE;
        }
        switch (value){
            case "public": return Authority.PUBLIC;
            case "private": return Authority.PRIVATE;
            default: return Authority.PRIVATE;
        }
    }

    public String getValue() {
        return value;
    }
}
