package cn.gtmap.gtc.document.clients.v1;

import cn.gtmap.gtc.document.domain.dto.Config;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zenglihuan
 * @create 2018/11/4 15:00
 * @discription
 **/
@FeignClient(name = "${app.services.document-app:document-app}")
@RequestMapping("/rest/v1/document")
public interface DocumentClient {

    @GetMapping("/public/viewer/{id}")
    public Config viewPublic(@PathVariable(name = "id") String id, @RequestParam(name = "secret") String secret);

    @GetMapping("/viewer/{id}")
    public Config view(@PathVariable(name = "id") String id);

    @GetMapping("/editor/{id}")
    public Config edit(@PathVariable(name = "id") String id, @RequestParam(name = "secret", required = false) String secret);

    @GetMapping("/common/viewer")
    public Config commonView(@RequestParam(name = "fileName") String fileName, @RequestParam(name = "downloadUrl") String downloadUrl,
                             @RequestParam(name = "user", required = false) String user, @RequestParam(name = "key", required = false) String key);

    @GetMapping("/common/editor")
    public Config commonEdit(@RequestParam(name = "fileName") String fileName, @RequestParam(name = "downloadUrl") String downloadUrl, @RequestParam(name = "callbackUrl") String callbackUrl,
                             @RequestParam(name = "user", required = false) String user, @RequestParam(name = "key", required = false) String key);

}
