package cn.gtmap.gtc.storage.domain.enums;

import org.springframework.util.StringUtils;

/**
 * @author zenglihuan
 * @create 2018/11/22 10:31
 * @discription 本地存储方式：年月日
 **/
public enum LocalStorageModeEnum
{
    YEAR("year"),
    MONTH("month"),
    DAY("day");

    String value;

    LocalStorageModeEnum(String value) {
        this.value = value;
    }

    public static LocalStorageModeEnum enumOfValue(String value){
        if(StringUtils.isEmpty(value)){
            return LocalStorageModeEnum.YEAR;
        }
        switch (value){
            case "year": return LocalStorageModeEnum.YEAR;
            case "month": return LocalStorageModeEnum.MONTH;
            case "day": return LocalStorageModeEnum.DAY;
            default: return LocalStorageModeEnum.YEAR;
        }
    }

    public String value(){
        return this.value;
    }

}