/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.expression;

import cn.gtmap.gtc.starter.gscas.expression.GtWebSecurityExpressionRoot;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestReaderHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    protected final Log logger = LogFactory.getLog(GtWebSecurityExpressionRoot.class);
    private byte[] body = null;

    public RequestReaderHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.body == null) {
            this.body = this.getBodyString().getBytes(Charset.forName("UTF-8"));
        }
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public String getBody() throws IOException {
        if (this.body == null) {
            this.body = this.getBodyString().getBytes(Charset.forName("UTF-8"));
        }
        return new String(this.body, Charset.forName("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBodyString() throws IOException {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = super.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            this.logger.warn((Object)"getBodyString", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.warn((Object)"inputStream close", (Throwable)e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.warn((Object)"reader close", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }
}

