/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.expression;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.starter.gcas.domain.UrlAuthAccess;
import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import cn.gtmap.gtc.starter.gcas.util.HttpUtils;
import cn.gtmap.gtc.starter.gscas.expression.RequestReaderHttpServletRequestWrapper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GtWebSecurityExpressionRoot
extends WebSecurityExpressionRoot {
    protected final Log logger = LogFactory.getLog(GtWebSecurityExpressionRoot.class);
    private static final String AUTH_TYPE = "session";
    private DiscoveryClient discoveryClient;
    private OAuth2RestTemplate template;
    private String username;
    private String requestPath;
    private String url;
    private String clientId;
    private String method;
    private String remoteAddr;
    public final HttpServletRequest httpServletRequest;

    public GtWebSecurityExpressionRoot(Authentication a, FilterInvocation fi, OAuth2RestTemplate template, String authPath, String clientId, DiscoveryClient discoveryClient) {
        super(a, fi);
        this.username = a.getName();
        this.template = template;
        this.clientId = clientId;
        this.url = authPath != null && authPath.lastIndexOf("/") != authPath.length() - 1 ? authPath + "/" : authPath;
        StringBuilder path = new StringBuilder();
        if (fi.getHttpRequest().getServletPath() != null) {
            path.append(fi.getHttpRequest().getServletPath());
            if (fi.getHttpRequest().getPathInfo() != null) {
                path.append(fi.getHttpRequest().getPathInfo());
            }
        }
        this.method = fi.getHttpRequest().getMethod();
        this.requestPath = path.toString();
        this.remoteAddr = ClientIpUtils.getRemoteHost((HttpServletRequest)fi.getRequest());
        this.discoveryClient = discoveryClient;
        this.httpServletRequest = fi.getHttpRequest();
    }

    public boolean hasAnyIpAddress(String ... ipAddress) {
        for (String ip : ipAddress) {
            boolean res = new IpAddressMatcher(ip).matches(this.request);
            if (!res) continue;
            return true;
        }
        return false;
    }

    public boolean isAccountAuthenticated() {
        UrlAuthAccess access = new UrlAuthAccess();
        access.setUrl(this.requestPath).setMethod(this.method).setClientId(this.clientId).setRemoteAddr(this.remoteAddr).setAuthType(AUTH_TYPE).setUsername(this.username).setRequestParams(this.getRequestParams(this.httpServletRequest));
        try {
            Random random;
            int n;
            ServiceInstance serviceInstance;
            String ipaAndPort;
            String requestUrl;
            String string;
            JSONObject object;
            Map map;
            List instances;
            RequestReaderHttpServletRequestWrapper wrapper = new RequestReaderHttpServletRequestWrapper(this.httpServletRequest);
            access.setRequestBody(wrapper.getBody());
            if (this.authentication instanceof OAuth2Authentication && ((OAuth2Authentication)this.authentication).isClientOnly()) {
                access.setAuthType("token");
            }
            if (!CollectionUtils.isEmpty((Collection)(instances = this.discoveryClient.getInstances("account"))) && (map = (object = JSON.parseObject((String)(string = HttpUtils.postJsonParams((String)(requestUrl = "http://".concat(ipaAndPort = (serviceInstance = (ServiceInstance)instances.get(n = (random = new Random()).nextInt(instances.size()))).getHost() + ":" + serviceInstance.getPort()).concat("/account/auth/url/access")), (String)ObjectMapperUtils.toJson((Object)access))))).getInnerMap()) != null) {
                if (map.get("code") != null && map.get("code").equals(0)) {
                    return true;
                }
                this.logger.warn((Object)("Account Authenticated fail: " + string));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"isAccountAuthenticated", (Throwable)e);
            return true;
        }
        return true;
    }

    private Map<String, String> getRequestParams(HttpServletRequest request) {
        HashMap map = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Map)request.getParameterMap())) {
            request.getParameterMap().forEach((k, v) -> {
                if (((String[])v).length == 1) {
                    map.put(k, v[0]);
                } else {
                    map.put(k, JSON.toJSONString((Object)v));
                }
            });
        }
        return map;
    }

    public boolean hasModuleAuthority(String authority) {
        if ("anonymousUser".equals(this.username)) {
            return this.hasAnyAuthority(new String[]{authority});
        }
        return this.moduleAuth(authority);
    }

    public boolean hasUrlAuthority(String authority) {
        if ("anonymousUser".equals(this.username)) {
            return this.hasAnyAuthority(new String[]{authority});
        }
        return this.urlAuth(authority);
    }

    public boolean hasAnyUrlAuthority(String ... authorities) {
        if ("anonymousUser".equals(this.username)) {
            return this.hasAnyAuthority(authorities);
        }
        if (authorities.length == 0) {
            return this.urlAuth("");
        }
        for (String authority : authorities) {
            if (!this.urlAuth(authority)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyModuleAuthority(String ... authorities) {
        if ("anonymousUser".equals(this.username)) {
            return this.hasAnyAuthority(authorities);
        }
        for (String authority : authorities) {
            if (!this.moduleAuth(authority)) continue;
            return true;
        }
        return false;
    }

    private boolean urlAuth(String authority) {
        if (null == this.template || null == this.url) {
            return false;
        }
        StringBuilder builder = new StringBuilder(this.url);
        builder.append("auth/menu/url-authority?username=").append(this.username).append("&path=").append(this.requestPath).append("&clientId=").append(this.clientId).append("&method=").append(this.method);
        Map authorityCode = (Map)this.template.getForObject(builder.toString(), Map.class, new Object[0]);
        if (CollectionUtils.isEmpty((Map)authorityCode)) {
            return false;
        }
        return this.verifyAuthority(authority, authorityCode);
    }

    private boolean moduleAuth(String authority) {
        Map authorityCode;
        if (null == this.template || null == this.url) {
            return false;
        }
        String[] args = authority.split(":");
        if (args.length < 1) {
            return false;
        }
        String moduleCode = args[0];
        String optStr = "";
        if (args.length > 1) {
            optStr = args[1];
        }
        if (CollectionUtils.isEmpty((Map)(authorityCode = (Map)this.template.getForObject(this.url + "auth/menu/module-authority?username=" + this.username + "&moduleCode=" + moduleCode + "&clientId=" + this.clientId, Map.class, new Object[0])))) {
            return false;
        }
        return this.verifyAuthority(optStr, authorityCode);
    }

    private boolean verifyAuthority(String optStr, Map<String, String> authority) {
        if (!StringUtils.isEmpty((Object)authority.get("root"))) {
            if ("all:all".equals(authority.get("root"))) {
                this.request.setAttribute("currentAuthority", (Object)authority.get("root"));
                this.request.setAttribute("elementAuthorities", (Object)authority.get("elements"));
                return true;
            }
            Set opts = StringUtils.commaDelimitedListToSet((String)optStr);
            if (!CollectionUtils.isEmpty((Collection)opts)) {
                for (String opt : opts) {
                    if (authority.get("root").contains(opt)) continue;
                    return false;
                }
            }
            this.request.setAttribute("currentAuthority", (Object)authority.get("root"));
            this.request.setAttribute("elementAuthorities", (Object)authority.get("elements"));
            return true;
        }
        return false;
    }
}

