/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config.handler;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class XssTimeFilter
extends OncePerRequestFilter {
    private RedisTemplate redisTemplate;

    public XssTimeFilter(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Map params = request.getParameterMap();
        if (!CollectionUtils.isEmpty((Map)params) && this.redisTemplate != null) {
            StringBuilder kb = new StringBuilder();
            Set kys = params.keySet();
            for (String k : kys) {
                if (!k.startsWith("_") || params.get(k) == null || ((String[])params.get(k)).length <= 0) continue;
                String timeFlag = ((String[])params.get(k))[0];
                if (XssTimeFilter.isNumeric(timeFlag)) {
                    long nowTime;
                    long time = Long.parseLong(timeFlag);
                    if (time >= (nowTime = System.currentTimeMillis()) - 300000L && time <= nowTime + 300000L) continue;
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u975e\u6cd5\u8de8\u7ad9\u8bf7\u6c42");
                }
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u975e\u6cd5\u8de8\u7ad9\u8bf7\u6c42");
            }
            if (kb.length() > 1) {
                String key;
                String csrfV = kb.toString();
                StringBuilder sb = new StringBuilder();
                Cookie[] cks = request.getCookies();
                if (cks != null) {
                    for (Cookie cookie : cks) {
                        String v = cookie.getValue();
                        if (StringUtils.isEmpty((Object)v)) continue;
                        sb.append(v);
                    }
                }
                if (!StringUtils.isEmpty((Object)(key = sb.toString()))) {
                    String csrfKey = "csrf:" + key;
                    Object o = this.redisTemplate.opsForValue().get((Object)csrfKey);
                    if (StringUtils.isEmpty((Object)o)) {
                        this.redisTemplate.opsForValue().set((Object)csrfKey, (Object)csrfV, 30L, TimeUnit.MINUTES);
                    } else {
                        String hv = o.toString();
                        if (!csrfV.equals(hv)) {
                            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8de8\u7ad9\u8bf7\u6c42");
                        }
                    }
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)httpServletResponse);
    }
}

