/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.session.SessionInformationExpiredEvent;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;

public class GtmapSessionInformationExpiredStrategy
implements SessionInformationExpiredStrategy {
    protected final Log logger = LogFactory.getLog(GtmapSessionInformationExpiredStrategy.class);

    public void onExpiredSessionDetected(SessionInformationExpiredEvent event) throws IOException, ServletException {
        HttpServletResponse response = event.getResponse();
        HttpServletRequest request = event.getRequest();
        response.setHeader("Refresh", "0");
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("delete cookie:" + cookie.getName()));
                }
                cookie.setMaxAge(0);
                response.addCookie(cookie);
            }
        }
        response.flushBuffer();
    }
}

