/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config.handler;

import cn.gtmap.gtc.starter.gcas.domain.SecurityMetaDataSource;
import cn.gtmap.gtc.starter.gscas.expression.RequestReaderHttpServletRequestWrapper;
import cn.gtmap.gtc.starter.gscas.expression.SecurityUrlConfig;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.util.CollectionUtils;

public class GtmapFilterSecurityInterceptor
extends AbstractSecurityInterceptor
implements Filter {
    private static final String FILTER_APPLIED = "__spring_security_filterSecurityInterceptor_filterApplied";
    private FilterInvocationSecurityMetadataSource securityMetadataSource;
    private boolean observeOncePerRequest = true;

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        this.invoke(fi);
    }

    public FilterInvocationSecurityMetadataSource getSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    public void setSecurityMetadataSource(FilterInvocationSecurityMetadataSource newSource) {
        this.securityMetadataSource = newSource;
    }

    public Class<?> getSecureObjectClass() {
        return FilterInvocation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(FilterInvocation fi) throws IOException, ServletException {
        if (fi.getRequest() != null && fi.getRequest().getAttribute(FILTER_APPLIED) != null && this.observeOncePerRequest) {
            fi.getChain().doFilter((ServletRequest)fi.getRequest(), (ServletResponse)fi.getResponse());
        } else {
            if (fi.getRequest() != null) {
                fi.getRequest().setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
            }
            FilterInvocation newFi = fi;
            boolean body = this.isNeedRequestBody(fi);
            if (body) {
                RequestReaderHttpServletRequestWrapper wrapper = new RequestReaderHttpServletRequestWrapper(fi.getRequest());
                newFi = new FilterInvocation((ServletRequest)wrapper, (ServletResponse)fi.getResponse(), fi.getChain());
            }
            InterceptorStatusToken token = super.beforeInvocation((Object)newFi);
            try {
                newFi.getChain().doFilter((ServletRequest)newFi.getRequest(), (ServletResponse)newFi.getResponse());
            }
            finally {
                super.finallyInvocation(token);
            }
            super.afterInvocation(token, null);
        }
    }

    private boolean isNeedRequestBody(FilterInvocation fi) {
        Collection attributes = this.obtainSecurityMetadataSource().getAttributes((Object)fi);
        if (!CollectionUtils.isEmpty((Collection)attributes)) {
            for (ConfigAttribute attribute : attributes) {
                SecurityUrlConfig securityUrlConfig;
                if (!(attribute instanceof SecurityUrlConfig) || CollectionUtils.isEmpty((securityUrlConfig = (SecurityUrlConfig)attribute).getDatas())) continue;
                for (SecurityMetaDataSource securityMetaDataSource : securityUrlConfig.getDatas()) {
                    if (!"body".equals(securityMetaDataSource.getParamFrom())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isObserveOncePerRequest() {
        return this.observeOncePerRequest;
    }

    public void setObserveOncePerRequest(boolean observeOncePerRequest) {
        this.observeOncePerRequest = observeOncePerRequest;
    }
}

