/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config.handler;

import cn.gtmap.gtc.starter.gscas.token.TokenDataRepo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GtOAuth2FeignRequestInterceptor
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(GtOAuth2FeignRequestInterceptor.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_TOKEN_TYPE = "bearer";
    private OAuth2RestTemplate oAuth2RestTemplate;
    private final OAuth2ProtectedResourceDetails details;
    private OkHttpClient okHttpClient;
    private AccessTokenProvider accessTokenProvider = new AccessTokenProviderChain(Arrays.asList(new AuthorizationCodeAccessTokenProvider(), new ImplicitAccessTokenProvider(), new ResourceOwnerPasswordAccessTokenProvider(), new ClientCredentialsAccessTokenProvider()));
    @Value(value="${app.security.feign.initToken:true}")
    private String initToken;

    protected OAuth2AccessToken acquireAccessToken(OAuth2ClientContext oauth2Context, OAuth2ProtectedResourceDetails resource) throws UserRedirectRequiredException {
        Authentication auth;
        AccessTokenRequest accessTokenRequest = oauth2Context.getAccessTokenRequest();
        if (accessTokenRequest == null) {
            throw new AccessTokenRequiredException("No OAuth 2 security context has been established. Unable to access resource '" + resource.getId() + "'.", resource);
        }
        String stateKey = accessTokenRequest.getStateKey();
        if (stateKey != null) {
            accessTokenRequest.setPreservedState(oauth2Context.removePreservedState(stateKey));
        }
        if ((auth = SecurityContextHolder.getContext().getAuthentication()) instanceof AnonymousAuthenticationToken && !resource.isClientOnly()) {
            throw new InsufficientAuthenticationException("Authentication is required to obtain an access token (anonymous not allowed)");
        }
        OAuth2AccessToken accessToken = null;
        OAuth2AccessToken existingToken = oauth2Context.getAccessToken();
        if (auth != null && auth.isAuthenticated()) {
            OAuth2RefreshToken refreshToken;
            if (existingToken != null) {
                accessTokenRequest.setExistingToken(existingToken);
            }
            accessToken = (refreshToken = existingToken.getRefreshToken()) != null && !resource.isClientOnly() ? this.accessTokenProvider.refreshAccessToken(resource, refreshToken, accessTokenRequest) : existingToken;
        }
        if (accessToken == null || accessToken.getValue() == null) {
            accessToken = existingToken;
        }
        oauth2Context.setAccessToken(accessToken);
        return accessToken;
    }

    public GtOAuth2FeignRequestInterceptor(OAuth2RestTemplate oAuth2RestTemplate, OAuth2ProtectedResourceDetails details) {
        Assert.notNull((Object)oAuth2RestTemplate, (String)"Context can not be null");
        this.oAuth2RestTemplate = oAuth2RestTemplate;
        this.details = details;
        this.okHttpClient = new OkHttpClient.Builder().retryOnConnectionFailure(false).connectionPool(new ConnectionPool(5, 1L, TimeUnit.MINUTES)).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
    }

    public void apply(RequestTemplate template) {
        block5: {
            if ("true".equals(this.initToken)) {
                try {
                    OAuth2AccessToken accessToken = this.oAuth2RestTemplate.getAccessToken();
                    if (accessToken != null && accessToken.getExpiresIn() < 200 || accessToken != null && accessToken.getExpiration() == null) {
                        String oldToken = accessToken.getValue();
                        accessToken = this.acquireAccessToken(this.oAuth2RestTemplate.getOAuth2ClientContext(), this.oAuth2RestTemplate.getResource());
                        logger.warn("change Token {} to {}", (Object)oldToken, (Object)accessToken.getValue());
                    }
                    template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER_TOKEN_TYPE, accessToken.toString())});
                }
                catch (Exception var3) {
                    String token = this.getAccessToken();
                    if (!StringUtils.isEmpty((Object)token)) {
                        template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER_TOKEN_TYPE, token)});
                    }
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("apply use client token:" + token, (Throwable)var3);
                }
            }
        }
    }

    private String postFormParams(String url, Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder();
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)builder.build()).build();
        return this.execNewCall(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execNewCall(Request request) {
        try (Response response = null;){
            response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            String string = null;
            return string;
        }
    }

    public String getAccessToken() {
        if (this.isExpire()) {
            return this.getNewAccessToken();
        }
        return TokenDataRepo.getInstance().getToken();
    }

    private boolean isExpire() {
        int time = TokenDataRepo.getInstance().getTime();
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now >= time - 1;
    }

    private String getNewAccessToken() {
        String authPath = this.details.getAccessTokenUri();
        if (!StringUtils.isEmpty((Object)authPath)) {
            StringBuilder builder = new StringBuilder(authPath);
            builder.append("?grant_type=client_credentials&client_id=").append(this.details.getClientId()).append("&client_secret=").append(this.details.getClientSecret());
            String res = this.postFormParams(builder.toString(), null);
            if (!StringUtils.isEmpty((Object)res)) {
                JSONObject object = JSON.parseObject((String)res);
                Map map = object.getInnerMap();
                if (map != null && null != map.get("access_token")) {
                    String accessToken = (String)map.get("access_token");
                    int expires = (Integer)map.get("expires_in");
                    int time = (int)(System.currentTimeMillis() / 1000L) + (expires -= 10);
                    TokenDataRepo.getInstance().updateToken(accessToken, time);
                    logger.warn("init client Token {} expires {}", (Object)accessToken, (Object)expires);
                    return accessToken;
                }
            } else {
                logger.error("getNewAccessToken: {}", (Object)res);
            }
        }
        return null;
    }
}

