/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.common.properties.security.AppSecurity;
import cn.gtmap.gtc.starter.gscas.config.OAuth2SsoCustomConfiguration;
import cn.gtmap.gtc.starter.gscas.config.SsoSecurityConfigurer;
import cn.gtmap.gtc.starter.gscas.config.handler.GtmapAccessDeniedHandler;
import cn.gtmap.gtc.starter.gscas.config.handler.GtmapFilterSecurityInterceptor;
import cn.gtmap.gtc.starter.gscas.config.handler.GtmapSessionInformationExpiredStrategy;
import cn.gtmap.gtc.starter.gscas.config.handler.GtmapSessionRegistryImpl;
import cn.gtmap.gtc.starter.gscas.endpoint.OtherAppAuthorizationEndpoint;
import cn.gtmap.gtc.starter.gscas.expression.GtAccessDecisionManager;
import cn.gtmap.gtc.starter.gscas.expression.GtWebExpressionVoter;
import cn.gtmap.gtc.starter.gscas.expression.GtWebSecurityExpressionHandler;
import cn.gtmap.gtc.starter.gscas.expression.GtmapFilterInvocationSecurityMetadataSource;
import cn.gtmap.gtc.starter.gscas.property.audit.AuditLogProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2SsoProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsUtils;

@Configuration
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Order(value=0x7FFFFFF8)
@AutoConfigureBefore(value={OAuth2SsoCustomConfiguration.class})
public class SsoWebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    final Logger logger = LoggerFactory.getLogger(SsoWebSecurityConfiguration.class);
    final ApplicationContext applicationContext;
    final OAuth2SsoProperties sso;
    final AppSecurity appSecurity;
    final OAuth2ProtectedResourceDetails details;
    final AuditLogProperties log;
    DiscoveryClient discoveryClient;
    @Value(value="${management.security.enabled:false}")
    private boolean managementSecurity;

    public SsoWebSecurityConfiguration(ApplicationContext applicationContext, OAuth2SsoProperties sso, AppSecurity appSecurity, OAuth2ProtectedResourceDetails details, AuditLogProperties log, DiscoveryClient discoveryClient) {
        this.applicationContext = applicationContext;
        this.sso = sso;
        this.appSecurity = appSecurity;
        this.details = details;
        this.log = log;
        this.discoveryClient = discoveryClient;
    }

    public GtWebSecurityExpressionHandler webSecurityExpressionHandler() {
        return new GtWebSecurityExpressionHandler(super.getApplicationContext(), this.appSecurity.getModuleAuthPath(), this.details.getClientId(), this.discoveryClient);
    }

    public GtWebExpressionVoter webExpressionVoter() {
        GtWebExpressionVoter webExpressionVoter = new GtWebExpressionVoter();
        webExpressionVoter.setDiscoveryClient(this.discoveryClient);
        webExpressionVoter.setExpressionHandler(this.webSecurityExpressionHandler());
        return webExpressionVoter;
    }

    public AccessDecisionManager accessDecisionManager() {
        ArrayList<AccessDecisionVoter<? extends Object>> decisionVoters = new ArrayList<AccessDecisionVoter<? extends Object>>();
        decisionVoters.add(this.webExpressionVoter());
        return new GtAccessDecisionManager(decisionVoters);
    }

    private GtmapFilterSecurityInterceptor createFilterSecurityInterceptor() {
        GtmapFilterSecurityInterceptor securityInterceptor = new GtmapFilterSecurityInterceptor();
        securityInterceptor.setSecurityMetadataSource(this.gtmapFilterInvocationSecurityMetadataSource());
        securityInterceptor.setAccessDecisionManager(this.accessDecisionManager());
        return securityInterceptor;
    }

    @Bean
    public GtmapFilterInvocationSecurityMetadataSource gtmapFilterInvocationSecurityMetadataSource() {
        return new GtmapFilterInvocationSecurityMetadataSource();
    }

    protected void configure(HttpSecurity http) throws Exception {
        Boolean anyAuthenticated = true;
        boolean preFlight = true;
        boolean csrf = false;
        boolean xssProtection = false;
        boolean xssProtectionBlock = false;
        boolean frameOption = false;
        boolean contentTypeOption = false;
        String accessDeniedPage = null;
        GtmapFilterSecurityInterceptor filterSecurityInterceptor = this.createFilterSecurityInterceptor();
        filterSecurityInterceptor.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        http.addFilterBefore((Filter)filterSecurityInterceptor, FilterSecurityInterceptor.class);
        block2: for (Map.Entry entry : this.appSecurity.getAuthorities().entrySet()) {
            try {
                if ("preFlight".equalsIgnoreCase((String)entry.getKey())) {
                    for (String value : (String[])entry.getValue()) {
                        if (!"false".equals(value)) continue;
                        preFlight = false;
                        continue block2;
                    }
                    continue;
                }
                if ("csrf".equalsIgnoreCase((String)entry.getKey())) {
                    for (String value : (String[])entry.getValue()) {
                        if (!"true".equals(value)) continue;
                        csrf = true;
                        continue block2;
                    }
                    continue;
                }
                if ("xssProtection".equalsIgnoreCase((String)entry.getKey())) {
                    for (String value : (String[])entry.getValue()) {
                        if (!"true".equals(value)) continue;
                        xssProtection = true;
                        continue block2;
                    }
                    continue;
                }
                if ("xssProtectionBlock".equalsIgnoreCase((String)entry.getKey())) {
                    for (String value : (String[])entry.getValue()) {
                        if (!"true".equals(value)) continue;
                        xssProtectionBlock = true;
                        continue block2;
                    }
                    continue;
                }
                if ("frameOption".equalsIgnoreCase((String)entry.getKey())) {
                    for (String value : (String[])entry.getValue()) {
                        if (!"true".equals(value)) continue;
                        frameOption = true;
                        continue block2;
                    }
                    continue;
                }
                if ("contentTypeOption".equalsIgnoreCase((String)entry.getKey())) {
                    for (String value : (String[])entry.getValue()) {
                        if (!"true".equals(value)) continue;
                        contentTypeOption = true;
                        continue block2;
                    }
                    continue;
                }
                if (!"accessDeniedPage".equalsIgnoreCase((String)entry.getKey())) continue;
                for (String value : (String[])entry.getValue()) {
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    accessDeniedPage = value;
                    continue block2;
                }
            }
            catch (Exception e) {
                this.logger.error("app.security.authorities has wrong key or values [{}]", (Object)e.getLocalizedMessage());
            }
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/authorize"})).authenticated().and();
        if (!preFlight) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().and();
        }
        if (anyAuthenticated != null && anyAuthenticated.booleanValue()) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        }
        if (!csrf) {
            http.csrf().disable();
        }
        if (xssProtection) {
            http.headers().xssProtection().xssProtectionEnabled(true).block(xssProtectionBlock);
        } else {
            http.headers().xssProtection().disable();
        }
        if (!contentTypeOption) {
            http.headers().contentTypeOptions().disable();
        }
        if (!frameOption) {
            http.headers().frameOptions().disable();
        }
        if (StringUtils.isNotBlank(accessDeniedPage)) {
            GtmapAccessDeniedHandler gtmapAccessDeniedHandler = this.gtmapAccessDeniedHandler();
            gtmapAccessDeniedHandler.setErrorPage(accessDeniedPage);
            http.exceptionHandling().accessDeniedHandler((AccessDeniedHandler)gtmapAccessDeniedHandler);
        }
        http.headers().cacheControl().disable();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).maximumSessions(-1).expiredSessionStrategy((SessionInformationExpiredStrategy)new GtmapSessionInformationExpiredStrategy()).sessionRegistry(this.sessionRegistry());
        new SsoSecurityConfigurer(this.applicationContext).configure(http);
    }

    @Bean
    public GtmapAccessDeniedHandler gtmapAccessDeniedHandler() {
        return new GtmapAccessDeniedHandler();
    }

    @Bean
    public OtherAppAuthorizationEndpoint otherAppAuthorizationEndpoint() {
        return new OtherAppAuthorizationEndpoint();
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        return new GtmapSessionRegistryImpl();
    }

    public void configure(WebSecurity web) throws Exception {
        try {
            if (this.appSecurity.getIgnores() != null) {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.appSecurity.getIgnores()));
                list.add("/prometheus");
                if (!this.managementSecurity) {
                    list.add("/health");
                    list.add("/info");
                }
                String[] array = list.toArray(new String[0]);
                web.ignoring().antMatchers(array);
            }
        }
        catch (Exception e) {
            this.logger.error("app.security.ignores has wrong values [{}]", (Object)e.getLocalizedMessage());
        }
    }
}

