/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.common.properties.security.AppSecurity;
import cn.gtmap.gtc.starter.gscas.annotation.ModuleAuthorityAspect;
import cn.gtmap.gtc.starter.gscas.config.handler.GtOAuth2FeignRequestInterceptor;
import cn.gtmap.gtc.starter.gscas.config.handler.GtmapOAuth2ClientContextFilter;
import feign.RequestInterceptor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;

@Configuration
public class SecurityAutoConfiguration {
    final ApplicationContext applicationContext;
    final AppSecurity appSecurity;
    final OAuth2ProtectedResourceDetails details;
    final DiscoveryClient discoveryClient;
    @Value(value="${app.publicOauth:none}")
    private String publicOauth;

    public SecurityAutoConfiguration(ApplicationContext applicationContext, AppSecurity appSecurity, OAuth2ProtectedResourceDetails details, DiscoveryClient discoveryClient) {
        this.applicationContext = applicationContext;
        this.appSecurity = appSecurity;
        this.details = details;
        this.discoveryClient = discoveryClient;
    }

    @Bean
    @Primary
    public OAuth2ClientContextFilter oauth2ClientContextFilter() {
        GtmapOAuth2ClientContextFilter filter = new GtmapOAuth2ClientContextFilter();
        return filter;
    }

    @Bean(value={"paascloudOAuth2RestTemplate"})
    OAuth2RestTemplate oAuth2RestTemplate(OAuth2ClientContext oAuth2ClientContext, OAuth2ProtectedResourceDetails details) {
        return new OAuth2RestTemplate(details, oAuth2ClientContext);
    }

    @Bean(value={"gtOAuth2FeignRequestInterceptor"})
    public RequestInterceptor gtOAuth2FeignRequestInterceptor(@Qualifier(value="paascloudOAuth2RestTemplate") OAuth2RestTemplate oAuth2RestTemplate) {
        return new GtOAuth2FeignRequestInterceptor(oAuth2RestTemplate, this.details);
    }

    @Bean
    public ModuleAuthorityAspect authorityActuatorAspect() {
        return new ModuleAuthorityAspect(this.discoveryClient, this.details.getClientId());
    }
}

