/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.starter.gcas.config.RabbitMqConfig;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={RabbitMqConfig.class})
public class EsRecordProduceConfig {
    @Autowired
    RabbitAdmin rabbitAdmin;

    @Bean(value={"esDirectExchange"})
    DirectExchange esDirectExchange() {
        DirectExchange exchange = new DirectExchange("es.record.produce");
        this.rabbitAdmin.declareExchange((Exchange)exchange);
        return exchange;
    }

    @Bean(value={"esRecordQueue"})
    Queue produceQueue() {
        Queue queue = new Queue("es.record.queue", true, false, false, null);
        this.rabbitAdmin.declareQueue(queue);
        return queue;
    }

    @Bean(value={"esRecordBinding"})
    Binding bindingProduceQueue() {
        Binding binding = BindingBuilder.bind((Queue)this.produceQueue()).to(this.esDirectExchange()).with("es");
        this.rabbitAdmin.declareBinding(binding);
        return binding;
    }
}

