/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.audit;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import cn.gtmap.gtc.starter.gscas.audit.LogClassifyAnalysis;
import cn.gtmap.gtc.starter.gscas.audit.LogSource;
import cn.gtmap.gtc.starter.gscas.property.audit.LogClassifyProperties;
import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ZipkinAuditEventRepository
implements AuditEventRepository {
    private static final Logger logger = LoggerFactory.getLogger(ZipkinAuditEventRepository.class);
    @Autowired
    private LogClassifyProperties logClassifyProperties;
    private final String appName;
    private RabbitTemplate rabbitTemplate;
    @Value(value="${logging.index.length:20000}")
    private int length;

    public ZipkinAuditEventRepository(String appName, RabbitTemplate rabbitTemplate) {
        this.appName = appName;
        this.rabbitTemplate = rabbitTemplate;
    }

    public void add(AuditEvent event) {
        Assert.notNull((Object)event, (String)"AuditEvent must not be null");
        try {
            Map<String, Object> data = LogClassifyAnalysis.collect(event.getData());
            if (!StringUtils.isEmpty((Object)event.getPrincipal())) {
                data.put("principal", event.getPrincipal());
            }
            data.put("event", event.getType());
            if (StringUtils.isEmpty((Object)data.get("logClassify")) && this.logClassifyProperties != null) {
                String requestUrl = ClientIpUtils.getRequestUrl(null);
                String classify = LogClassifyAnalysis.getClassify(requestUrl, this.logClassifyProperties);
                data.put("logClassify", classify);
            }
            if (!StringUtils.isEmpty((Object)this.appName)) {
                data.put("gtcAppName", this.appName);
            }
            LogSource source = this.conventLogSource(data);
            source.setId(UUID.randomUUID().toString());
            if ("AUTHENTICATION_FAILURE".equals(event.getType()) || "AUTHENTICATION_SUCCESS".equals(event.getType()) || "AUTHENTICATION_SWITCH".equals(event.getType()) || "AUTHORIZATION_FAILURE".equals(event.getType()) || "AUTHORIZATION_SUCCESS".equals(event.getType())) {
                this.send(null, source.getId(), "security", "save", JSON.toJSONString((Object)source));
            } else {
                this.send(null, source.getId(), "platform", "save", JSON.toJSONString((Object)source));
            }
        }
        catch (Exception e) {
            logger.warn("add", (Throwable)e);
        }
    }

    @Deprecated
    public void newSpanTag(AuditEvent event, String spanName) {
        this.add(event);
    }

    public List<AuditEvent> find(Date after) {
        return this.find(null, after, null);
    }

    public List<AuditEvent> find(String principal, Date after) {
        return this.find(principal, after, null);
    }

    public List<AuditEvent> find(String principal, Date after, String type) {
        return Collections.emptyList();
    }

    public String buildValue(Object arg) {
        String className;
        if (null == arg) {
            return "unknown";
        }
        switch (className = arg.getClass().getName()) {
            case "java.lang.String": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Short": 
            case "java.lang.Byte": {
                return arg.toString();
            }
        }
        return JSON.toJSONString((Object)arg);
    }

    private LogSource conventLogSource(Map<String, Object> data) {
        LogSource source = new LogSource();
        if (data.get("current.url") != null) {
            source.setName(data.get("current.url").toString());
        }
        data.remove("current.url");
        if (data.get("current.method") != null) {
            source.setMethod(data.get("current.method").toString());
        }
        data.remove("current.method");
        source.setTimestamp_millis((Date)data.get("timestamp"));
        data.remove("timestamp");
        source.setTimestamp((Long)data.get("timestamp_millis"));
        data.remove("timestamp_millis");
        LinkedList<String> p = new LinkedList<String>();
        Iterator<Map.Entry<String, Object>> it = data.entrySet().iterator();
        HashMap<String, String> tags = new HashMap<String, String>();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            p.add(entry.getKey());
            String value = this.buildValue(entry.getValue());
            if (value.length() <= this.length) {
                p.add(entry.getKey().concat("=").concat(value));
            }
            tags.put(entry.getKey(), value);
        }
        source.set_q(p);
        source.setTags(tags);
        return source;
    }

    public void send(String index, String id, String type, String operate, String jsonData) {
        if (!StringUtils.isEmpty((Object)jsonData)) {
            HashMap<String, String> log = new HashMap<String, String>();
            if (!StringUtils.isEmpty((Object)id)) {
                log.put("id", id);
            }
            if (!StringUtils.isEmpty((Object)index)) {
                log.put("index", index);
            }
            if (StringUtils.isEmpty((Object)operate)) {
                operate = "save";
            }
            log.put("operate", operate);
            if (!StringUtils.isEmpty((Object)type)) {
                log.put("type", type);
            }
            log.put("jsonData", jsonData);
            try {
                CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                this.rabbitTemplate.convertAndSend("es.record.produce", "es", (Object)ObjectMapperUtils.toJson(log), correlationData);
            }
            catch (Exception e) {
                logger.error("RabbitmqLogSender", (Throwable)e);
            }
        } else {
            logger.error("RabbitmqLogSender send empty json data!");
        }
    }
}

