/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.audit;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.starter.gcas.util.HttpUtils;
import cn.gtmap.gtc.starter.gscas.audit.LogClassifyAnalysis;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CustomAuditEventRepository {
    public static final String LOG_APP_SERVICE_ID = "log-app";
    private static final Logger logger = LoggerFactory.getLogger(CustomAuditEventRepository.class);
    private DiscoveryClient discoveryClient;
    private RabbitTemplate rabbitTemplate;

    public CustomAuditEventRepository(DiscoveryClient discoveryClient, RabbitTemplate rabbitTemplate) {
        this.discoveryClient = discoveryClient;
        this.rabbitTemplate = rabbitTemplate;
    }

    public void add(String index, String id, Map<String, Object> data) {
        Assert.hasLength((String)index, (String)"\u53c2\u6570\u7f3a\u7d22\u5f15\u503c");
        try {
            data = LogClassifyAnalysis.collect(data);
            if (this.rabbitTemplate != null) {
                this.rabbitMqsend(index, id, data);
            } else {
                this.httpSend(index, id, data);
            }
        }
        catch (Exception e) {
            logger.warn("add", (Throwable)e);
        }
    }

    private void httpSend(String index, String id, Map<String, Object> data) {
        List instances = this.discoveryClient.getInstances(LOG_APP_SERVICE_ID);
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            Random random = new Random();
            int n = random.nextInt(instances.size());
            ServiceInstance serviceInstance = (ServiceInstance)instances.get(n);
            String ipaAndPort = serviceInstance.getHost() + ":" + serviceInstance.getPort();
            String requestUrl = "http://".concat(ipaAndPort).concat("/rest/v1/customs").concat("?index=").concat(index).concat("&id=").concat(id);
            HttpUtils.postJsonParams((String)requestUrl, (String)ObjectMapperUtils.toJson(data));
        }
    }

    private void rabbitMqsend(String index, String id, Map<String, Object> data) {
        HashMap<String, String> log = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)id)) {
            log.put("id", id);
        }
        log.put("index", index);
        log.put("operate", "save");
        log.put("jsonData", ObjectMapperUtils.toJson(data));
        CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
        this.rabbitTemplate.convertAndSend("es.record.produce", "es", (Object)ObjectMapperUtils.toJson(log), correlationData);
    }
}

