/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.expression;

import cn.gtmap.gtc.starter.gcas.domain.SecurityMetaDataSource;
import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import cn.gtmap.gtc.starter.gcas.util.HttpUtils;
import cn.gtmap.gtc.starter.gscas.expression.RequestReaderHttpServletRequestWrapper;
import cn.gtmap.gtc.starter.gscas.expression.SecurityUrlConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GtWebExpressionVoter
implements AccessDecisionVoter<FilterInvocation> {
    private static final Logger logger = LoggerFactory.getLogger(GtWebExpressionVoter.class);
    private DiscoveryClient discoveryClient;
    private SecurityExpressionHandler<FilterInvocation> expressionHandler = new DefaultWebSecurityExpressionHandler();

    public void setDiscoveryClient(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, FilterInvocation fi, Collection<ConfigAttribute> attributes) {
        assert (authentication != null);
        assert (fi != null);
        assert (attributes != null);
        EvaluationContext ctx = this.expressionHandler.createEvaluationContext(authentication, (Object)fi);
        String expression = attributes.toArray(new ConfigAttribute[1])[0].getAttribute();
        boolean urlAccess = ExpressionUtils.evaluateAsBoolean((Expression)this.expressionHandler.getExpressionParser().parseExpression(expression), (EvaluationContext)ctx);
        if (urlAccess) {
            return this.dataAccess(authentication, attributes, fi.getHttpRequest());
        }
        return -1;
    }

    private int dataAccess(Authentication authentication, Collection<ConfigAttribute> attributes, HttpServletRequest httpRequest) {
        ConfigAttribute attribute = attributes.toArray(new ConfigAttribute[1])[0];
        if (attribute instanceof SecurityUrlConfig) {
            List<SecurityMetaDataSource> datas = ((SecurityUrlConfig)attribute).getDatas();
            if (CollectionUtils.isEmpty(datas)) {
                return 1;
            }
            for (SecurityMetaDataSource securityMetaDataSource : datas) {
                if (this.verifyData(authentication, securityMetaDataSource, httpRequest)) continue;
                return -1;
            }
        }
        return 1;
    }

    private boolean verifyData(Authentication authentication, SecurityMetaDataSource dataSource, HttpServletRequest request) {
        try {
            String dataId;
            if (logger.isDebugEnabled()) {
                logger.debug(dataSource.toString());
            }
            if (StringUtils.isEmpty((Object)(dataId = this.getDataId(dataSource, request)))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("getDataId is null !");
                }
                return false;
            }
            String clientIp = ClientIpUtils.getRemoteHost((HttpServletRequest)request);
            if ("local".equals(dataSource.getAccessType())) {
                return this.localDataAccess(authentication.getName(), dataSource.getAuthorities(), dataSource.getDataType(), dataId, clientIp);
            }
            return this.remoteDataAccess(authentication.getName(), dataSource, dataId, clientIp);
        }
        catch (Exception e) {
            logger.error("verifyData", (Throwable)e);
            return false;
        }
    }

    private boolean remoteDataAccess(String username, SecurityMetaDataSource dataSource, String dataId, String clientIp) {
        String url = dataSource.getAccessUrl();
        if (!StringUtils.isEmpty((Object)dataSource.getAppName())) {
            List instances = this.discoveryClient.getInstances(dataSource.getAppName());
            if (!CollectionUtils.isEmpty((Collection)instances)) {
                Random random = new Random();
                int n = random.nextInt(instances.size());
                ServiceInstance serviceInstance = (ServiceInstance)instances.get(n);
                String ipaAndPort = serviceInstance.getHost().concat(":").concat(serviceInstance.getPort() + "");
                url = url.replace("${appName}", ipaAndPort);
            } else {
                return false;
            }
        }
        HashMap query = Maps.newHashMap();
        query.put("username", username);
        query.put("code", dataId);
        query.put("clientIp", clientIp);
        String res = null;
        if (HttpMethod.GET.name().equals(dataSource.getMethod())) {
            res = HttpUtils.get((String)url, (Map)query, null);
        } else if (HttpMethod.POST.name().equals(dataSource.getMethod())) {
            res = HttpUtils.post((String)url, null, (Map)query, null);
        } else if (HttpMethod.PUT.name().equals(dataSource.getMethod())) {
            res = HttpUtils.put((String)url, null, (Map)query, null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("remoteDataAccess url:{} res:{}", (Object)url, (Object)res);
        }
        return this.conventResult(res, dataSource.getAuthorities());
    }

    private boolean localDataAccess(String username, String limit, String dataType, String dataId, String clientIp) {
        String res = null;
        List instances = this.discoveryClient.getInstances("account");
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            Random random = new Random();
            int n = random.nextInt(instances.size());
            ServiceInstance serviceInstance = (ServiceInstance)instances.get(n);
            String ipaAndPort = serviceInstance.getHost().concat(":").concat(serviceInstance.getPort() + "");
            String requestUrl = "http://".concat(ipaAndPort).concat("/account/auth/data/authority");
            HashMap query = Maps.newHashMap();
            query.put("username", username);
            query.put("dataType", dataType);
            query.put("code", dataId);
            query.put("clientIp", clientIp);
            res = HttpUtils.get((String)requestUrl, (Map)query, null);
            if (logger.isDebugEnabled()) {
                logger.debug("localDataAccess url:{} res:{}", (Object)requestUrl, (Object)res);
            }
        }
        return this.conventResult(res, limit);
    }

    private boolean conventResult(String res, String limit) {
        JSONObject result;
        if (!StringUtils.isEmpty((Object)res) && (result = JSON.parseObject((String)res)).containsKey((Object)"code") && result.getInteger("code") == 0) {
            if (StringUtils.isEmpty((Object)limit)) {
                return true;
            }
            Set limits = StringUtils.commaDelimitedListToSet((String)limit);
            Set authorities = StringUtils.commaDelimitedListToSet((String)result.getString("authorities"));
            if (authorities.containsAll(limits)) {
                return true;
            }
        }
        return false;
    }

    private String getDataId(SecurityMetaDataSource dataSource, HttpServletRequest request) throws Exception {
        String body;
        if (StringUtils.isEmpty((Object)dataSource.getParams())) {
            return null;
        }
        if ("param".equals(dataSource.getParamFrom())) {
            return ClientIpUtils.getRequestParam((HttpServletRequest)request, (String)dataSource.getParams());
        }
        if ("body".equals(dataSource.getParamFrom()) && request instanceof RequestReaderHttpServletRequestWrapper && !StringUtils.isEmpty((Object)(body = ((RequestReaderHttpServletRequestWrapper)request).getBody()))) {
            JSONObject object = JSON.parseObject((String)body);
            String[] params = dataSource.getParams().split("\\.");
            if (params.length == 1) {
                if (object.containsKey((Object)dataSource.getParams())) {
                    return object.getString(dataSource.getParams());
                }
            } else {
                for (int i = 0; i < params.length; ++i) {
                    String p = params[i];
                    if (!object.containsKey((Object)p)) continue;
                    if (i == params.length - 1) {
                        return object.getString(p);
                    }
                    object = object.getJSONObject(p);
                }
            }
        }
        if ("url".equals(dataSource.getParamFrom())) {
            AntPathMatcher matcher = new AntPathMatcher();
            Map params = matcher.extractUriTemplateVariables(dataSource.getParams(), request.getServletPath());
            return (String)params.get("code");
        }
        return null;
    }

    public void setExpressionHandler(SecurityExpressionHandler<FilterInvocation> expressionHandler) {
        this.expressionHandler = expressionHandler;
    }
}

