/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.starter.gscas.config.handler.XssTimeFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@ConditionalOnProperty(prefix="filter.xss.time", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class XssTimeConfigure
implements BeanClassLoaderAware {
    private ClassLoader classLoader;
    private RedisConnectionFactory redisConnectionFactory;
    private RedisTemplate xssTimeRedisTemplate;

    private RedisTemplate<Object, Object> xssTimeRedisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setDefaultSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        redisTemplate.setConnectionFactory(this.redisConnectionFactory);
        redisTemplate.setBeanClassLoader(this.classLoader);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    public XssTimeConfigure(ObjectProvider<RedisConnectionFactory> redisConnectionFactory) {
        RedisConnectionFactory redisConnectionFactoryToUse;
        this.redisConnectionFactory = redisConnectionFactoryToUse = (RedisConnectionFactory)redisConnectionFactory.getObject();
        this.xssTimeRedisTemplate = this.xssTimeRedisTemplate();
    }

    @Bean(value={"gtmapXssTimeFilter"})
    public FilterRegistrationBean gtmapXssTimeFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new XssTimeFilter(this.xssTimeRedisTemplate), new ServletRegistrationBean[0]);
        return bean;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

