/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.audit;

import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import cn.gtmap.gtc.starter.gscas.property.audit.LogClassifyProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class LogClassifyAnalysis {
    public static final String REMOTE_ADDR = "remoteAddr";
    public static final String PRINCIPAL = "principal";
    public static final String EVENT = "event";
    public static final String METHOD = "current.method";
    public static final String URL = "current.url";
    public static final String LOG_CLASSIFY = "logClassify";
    public static final String APP_NAME = "gtcAppName";
    public static final String NEW_SPAN = "newSpan";

    public static String getClassify(String requestUrl, LogClassifyProperties logClassifyProperties) {
        String classify = logClassifyProperties.getDefaulted();
        if (!StringUtils.isEmpty((Object)requestUrl) && !CollectionUtils.isEmpty(logClassifyProperties.getPath())) {
            AntPathMatcher matcher = new AntPathMatcher();
            for (Map.Entry<String, String[]> entry : logClassifyProperties.getPath().entrySet()) {
                if (!ClientIpUtils.matchUrl((PathMatcher)matcher, (String[])entry.getValue(), (String)requestUrl)) continue;
                return entry.getKey();
            }
        }
        return classify;
    }

    public static Map<String, Object> collect(Map<String, Object> map) {
        HttpServletRequest request;
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (map != null) {
            data.putAll(map);
        }
        if ((request = ClientIpUtils.getRequest()) != null) {
            if (StringUtils.isEmpty(data.get(REMOTE_ADDR))) {
                data.put(REMOTE_ADDR, ClientIpUtils.getRemoteHost((HttpServletRequest)request));
            }
            if (StringUtils.isEmpty(data.get(URL))) {
                data.put(URL, ClientIpUtils.getRequestUrl((HttpServletRequest)request));
            }
            if (StringUtils.isEmpty(data.get(METHOD))) {
                data.put(METHOD, ClientIpUtils.getRequestUrl((HttpServletRequest)request));
            }
        }
        if (StringUtils.isEmpty(data.get(EVENT))) {
            data.put(EVENT, "CUSTOM_EVENT");
        }
        if (data.get("timestamp_millis") == null) {
            data.put("timestamp_millis", System.currentTimeMillis());
        }
        if (data.get("timestamp") == null) {
            data.put("timestamp", new Date());
        }
        if (StringUtils.isEmpty(data.get(PRINCIPAL))) {
            String principal = "unknown";
            if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
                principal = SecurityContextHolder.getContext().getAuthentication().getName();
            }
            data.put(PRINCIPAL, principal);
        }
        return data;
    }
}

