/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.annotation;

import cn.gtmap.gtc.starter.gscas.annotation.ModuleAuthority;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class ModuleAuthorityAspect {
    static final Logger log = LoggerFactory.getLogger(ModuleAuthorityAspect.class);
    private RestTemplate template;
    private String clientId;
    private DiscoveryClient discoveryClient;

    public ModuleAuthorityAspect(DiscoveryClient discoveryClient, String clientId) {
        this.clientId = clientId;
        this.discoveryClient = discoveryClient;
        this.template = new RestTemplate();
    }

    @Pointcut(value="@annotation(authorityActuator)")
    public void AuthorityAspect(ModuleAuthority authorityActuator) {
    }

    @Before(value="AuthorityAspect(authorityActuator)")
    public void doBefore(JoinPoint joinPoint, ModuleAuthority authorityActuator) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        if (!StringUtils.isEmpty((Object)authorityActuator.code())) {
            if (!this.isEmptyCurrentAuthority(request)) {
                String authority = (String)request.getAttribute("currentAuthority");
                String[] moduleCodeArr = authority.split(":");
                if (authorityActuator.code().equals(moduleCodeArr[0]) || "all".equals(moduleCodeArr[0])) {
                    return;
                }
            }
            this.setModuleCurrentAuthority(request, authorityActuator.code());
        } else if (!StringUtils.isEmpty((Object)authorityActuator.path())) {
            this.setUrlCurrentAuthority(request, authorityActuator.path(), authorityActuator.method());
        } else {
            if (!this.isEmptyCurrentAuthority(request)) {
                return;
            }
            StringBuilder path = new StringBuilder();
            if (request.getServletPath() != null) {
                path.append(request.getServletPath());
                if (request.getPathInfo() != null) {
                    path.append(request.getPathInfo());
                }
            }
            this.setUrlCurrentAuthority(request, path.toString(), request.getMethod());
        }
    }

    private boolean isEmptyCurrentAuthority(HttpServletRequest request) {
        return StringUtils.isEmpty((Object)request.getAttribute("currentAuthority"));
    }

    private String getAccountUrl() {
        List instances = this.discoveryClient.getInstances("account");
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            Random random = new Random();
            int n = random.nextInt(instances.size());
            ServiceInstance serviceInstance = (ServiceInstance)instances.get(n);
            String ipaAndPort = serviceInstance.getHost() + ":" + serviceInstance.getPort();
            String requestUrl = "http://".concat(ipaAndPort).concat("/account/");
            return requestUrl;
        }
        return null;
    }

    private void setModuleCurrentAuthority(HttpServletRequest request, String moduleCode) {
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            String username = SecurityContextHolder.getContext().getAuthentication().getName();
            if ("anonymousUser".equals(username)) {
                request.setAttribute("currentAuthority", (Object)"");
                return;
            }
            String authPath = this.getAccountUrl();
            if (!StringUtils.isEmpty((Object)authPath)) {
                StringBuilder builder = new StringBuilder(authPath);
                builder.append("auth/menu/module-authority?username=").append(username).append("&moduleCode=").append(moduleCode).append("&clientId=").append(this.clientId);
                Map authorityCode = (Map)this.template.getForObject(builder.toString(), Map.class, new Object[0]);
                request.setAttribute("currentAuthority", authorityCode.get("root"));
                request.setAttribute("elementAuthorities", authorityCode.get("elements"));
                if (log.isDebugEnabled()) {
                    log.debug("set currentAuthority ==>" + authorityCode);
                }
            }
        } else {
            request.setAttribute("currentAuthority", (Object)"");
        }
    }

    private void setUrlCurrentAuthority(HttpServletRequest request, String requestPath, String method) {
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            String authPath;
            String username = SecurityContextHolder.getContext().getAuthentication().getName();
            if ("anonymousUser".equals(username)) {
                request.setAttribute("currentAuthority", (Object)"");
                return;
            }
            if (StringUtils.isEmpty((Object)method)) {
                method = "GET";
            }
            if (!StringUtils.isEmpty((Object)(authPath = this.getAccountUrl()))) {
                StringBuilder builder = new StringBuilder(authPath);
                builder.append("auth/menu/url-authority?username=").append(username).append("&path=").append(requestPath).append("&clientId=").append(this.clientId).append("&method=").append(method.toUpperCase());
                Map authorityCode = (Map)this.template.getForObject(builder.toString(), Map.class, new Object[0]);
                request.setAttribute("currentAuthority", authorityCode.get("root"));
                request.setAttribute("elementAuthorities", authorityCode.get("elements"));
                if (log.isDebugEnabled()) {
                    log.debug("set currentAuthority ==>" + authorityCode);
                }
            }
        } else {
            request.setAttribute("currentAuthority", (Object)"");
        }
    }
}

