/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.annotation;

import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import cn.gtmap.gtc.starter.gscas.annotation.AuditLog;
import cn.gtmap.gtc.starter.gscas.audit.LogClassifyAnalysis;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.gtc.starter.gscas.property.audit.LogClassifyProperties;
import com.google.common.collect.Maps;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;

@Aspect
public class LogAspect {
    static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    @Autowired
    private LogClassifyProperties logClassifyProperties;
    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;

    @Pointcut(value="@annotation(logActuator)")
    public void LogAspect(AuditLog logActuator) {
    }

    @AfterReturning(returning="response", pointcut="LogAspect(logActuator)")
    public void doAfter(JoinPoint joinPoint, AuditLog logActuator, Object response) {
        Object[] args;
        if (StringUtils.isEmpty((Object)logActuator.event())) {
            if (log.isDebugEnabled()) {
                log.debug("method: " + joinPoint.getSignature().getName() + " log event is empty!");
            }
            return;
        }
        String[] names = logActuator.names();
        HashMap data = Maps.newHashMap();
        if (logActuator.request() && null != (args = joinPoint.getArgs()) && args.length > 0) {
            int j = 0;
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                if (o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof Model || o instanceof ModelAndView || o instanceof Principal || o instanceof Authentication || o instanceof OAuth2Authentication) continue;
                data.put(this.getArgName(names, j), o);
                ++j;
            }
        }
        data.put("current.method", joinPoint.getSignature().getName());
        if (null != response && logActuator.response()) {
            data.put("response", response);
        }
        String principal = "unknown";
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            principal = SecurityContextHolder.getContext().getAuthentication().getName();
        }
        HttpServletRequest request = ClientIpUtils.getRequest();
        data.put("remoteAddr", ClientIpUtils.getRemoteHost((HttpServletRequest)request));
        String requestUrl = ClientIpUtils.getRequestUrl((HttpServletRequest)request);
        data.put("current.url", requestUrl);
        String classify = LogClassifyAnalysis.getClassify(requestUrl, this.logClassifyProperties);
        data.put("logClassify", classify);
        if (logActuator.newSpan()) {
            data.put("newSpan", logActuator.newSpan());
        }
        this.zipkinAuditEventRepository.add(new AuditEvent(principal, logActuator.event(), (Map)data));
    }

    private String getArgName(String[] names, Integer index) {
        if (names != null && names.length > index) {
            return names[index];
        }
        return "arg[".concat(index.toString()).concat("]");
    }
}

