/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.annotation;

import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import cn.gtmap.gtc.starter.gscas.annotation.ExceptionLog;
import cn.gtmap.gtc.starter.gscas.audit.LogClassifyAnalysis;
import cn.gtmap.gtc.starter.gscas.property.audit.LogClassifyProperties;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;

@Aspect
public class ExceptionLogAspect
implements ApplicationEventPublisherAware {
    static final Logger log = LoggerFactory.getLogger(ExceptionLogAspect.class);
    private ApplicationEventPublisher publisher;
    @Autowired
    private LogClassifyProperties logClassifyProperties;

    @Pointcut(value="@within(exceptionLog)")
    public void ExceptionLogAspect(ExceptionLog exceptionLog) {
    }

    @AfterThrowing(pointcut="ExceptionLogAspect(exceptionLog)", throwing="ex")
    public void doAfter(JoinPoint joinPoint, ExceptionLog exceptionLog, Exception ex) {
        if (StringUtils.isEmpty((Object)exceptionLog.event())) {
            if (log.isDebugEnabled()) {
                log.debug("method: ".concat(joinPoint.getSignature().getName()).concat(" log event is empty!"));
            }
            return;
        }
        Object[] args = joinPoint.getArgs();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (null != args && args.length > 0) {
            int j = 0;
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                if (o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof Model || o instanceof ModelAndView || o instanceof Principal || o instanceof Authentication || o instanceof OAuth2Authentication) continue;
                data.put(this.getArgName(j), o);
                ++j;
            }
        }
        String principal = "unknown";
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            principal = SecurityContextHolder.getContext().getAuthentication().getName();
        }
        StackTraceElement stackTraceElement = ex.getStackTrace()[0];
        data.put("exception.line", stackTraceElement.getFileName().concat(":").concat("" + stackTraceElement.getLineNumber()));
        data.put("exception.method", stackTraceElement.getClassName().concat(".").concat(stackTraceElement.getMethodName()));
        data.put("exception.case", ex.toString());
        String classify = LogClassifyAnalysis.getClassify(ClientIpUtils.getRequestUrl(null), this.logClassifyProperties);
        data.put("logClassify", classify);
        this.publish(new AuditEvent(principal, exceptionLog.event(), data));
    }

    private String getArgName(Integer index) {
        return "arg[".concat(index.toString()).concat("]");
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getPublisher() {
        return this.publisher;
    }

    protected void publish(AuditEvent event) {
        if (this.getPublisher() != null) {
            this.getPublisher().publishEvent((ApplicationEvent)new AuditApplicationEvent(event));
        }
    }
}

