/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.expression;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class GtmapFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    protected static final Log logger = LogFactory.getLog(GtmapFilterInvocationSecurityMetadataSource.class);
    private static volatile int write = 0;
    public static boolean localAuthenticated = true;
    public static String[] localScopes = null;
    public static ReentrantLock lock = new ReentrantLock();
    private static Map<RequestMatcher, Collection<ConfigAttribute>> requestMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>(10);

    public GtmapFilterInvocationSecurityMetadataSource() {
    }

    public GtmapFilterInvocationSecurityMetadataSource(LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap) {
        GtmapFilterInvocationSecurityMetadataSource.requestMap = requestMap;
    }

    public static void setRequestMap(Map<RequestMatcher, Collection<ConfigAttribute>> map) {
        if (map == null) {
            return;
        }
        write = 1;
        try {
            if (lock.tryLock(3L, TimeUnit.SECONDS)) {
                requestMap = map;
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)"setRequestMap", (Throwable)e);
        }
        finally {
            write = 0;
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    private static Map<RequestMatcher, Collection<ConfigAttribute>> getRequestMap() {
        block8: {
            if (write == 1) {
                try {
                    if (lock.tryLock(3L, TimeUnit.SECONDS)) {
                        Map<RequestMatcher, Collection<ConfigAttribute>> map = requestMap;
                        return map;
                    }
                    break block8;
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"getRequestMap", (Throwable)e);
                    Map<RequestMatcher, Collection<ConfigAttribute>> map = Collections.emptyMap();
                    return map;
                }
                finally {
                    if (lock.isHeldByCurrentThread()) {
                        lock.unlock();
                    }
                }
            }
            return requestMap;
        }
        return Collections.emptyMap();
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> allAttributes = new HashSet<ConfigAttribute>();
        for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : GtmapFilterInvocationSecurityMetadataSource.getRequestMap().entrySet()) {
            allAttributes.addAll(entry.getValue());
        }
        return allAttributes;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) {
        HttpServletRequest request = ((FilterInvocation)object).getRequest();
        for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : GtmapFilterInvocationSecurityMetadataSource.getRequestMap().entrySet()) {
            if (!entry.getKey().matches(request)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }
}

