/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.expression;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.provider.expression.OAuth2ExpressionUtils;

public class GtOAuth2SecurityExpressionMethods {
    private final Authentication authentication;
    private Set<String> missingScopes = new LinkedHashSet<String>();

    public GtOAuth2SecurityExpressionMethods(Authentication authentication) {
        this.authentication = authentication;
    }

    public boolean throwOnError(boolean decision) {
        if (!decision && !this.missingScopes.isEmpty()) {
            InsufficientScopeException failure = new InsufficientScopeException("Insufficient scope for this resource", this.missingScopes);
            throw new AccessDeniedException(failure.getMessage(), (Throwable)failure);
        }
        return decision;
    }

    public boolean clientHasRole(String role) {
        return this.clientHasAnyRole(role);
    }

    public boolean clientHasAnyRole(String ... roles) {
        return OAuth2ExpressionUtils.clientHasAnyRole((Authentication)this.authentication, (String[])roles);
    }

    public boolean hasScope(String scope) {
        return this.hasAnyScope(scope);
    }

    public boolean hasAnyScope(String ... scopes) {
        boolean result = OAuth2ExpressionUtils.hasAnyScope((Authentication)this.authentication, (String[])scopes);
        if (!result) {
            this.missingScopes.addAll(Arrays.asList(scopes));
        }
        return result;
    }

    public boolean hasScopeMatching(String scopeRegex) {
        return this.hasAnyScopeMatching(scopeRegex);
    }

    public boolean hasAnyScopeMatching(String ... scopesRegex) {
        boolean result = OAuth2ExpressionUtils.hasAnyScopeMatching((Authentication)this.authentication, (String[])scopesRegex);
        if (!result) {
            this.missingScopes.addAll(Arrays.asList(scopesRegex));
        }
        return result;
    }

    public boolean denyOAuthClient() {
        return !OAuth2ExpressionUtils.isOAuth((Authentication)this.authentication);
    }

    public boolean isOAuth() {
        return OAuth2ExpressionUtils.isOAuth((Authentication)this.authentication);
    }

    public boolean isUser() {
        return OAuth2ExpressionUtils.isOAuthUserAuth((Authentication)this.authentication);
    }

    public boolean isClient() {
        return OAuth2ExpressionUtils.isOAuthClientAuth((Authentication)this.authentication);
    }
}

