/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config.handler;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class GtmapOAuth2ClientContextFilter
extends OAuth2ClientContextFilter {
    protected static final Log logger = LogFactory.getLog(GtmapOAuth2ClientContextFilter.class);
    @Value(value="${app.publicOauth:none}")
    private String publicOauth;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.redirectStrategy, (String)"A redirect strategy must be supplied.");
    }

    protected void redirectUser(UserRedirectRequiredException e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectUri = e.getRedirectUri();
        if (!StringUtils.isEmpty((Object)this.publicOauth) && !"none".equals(this.publicOauth)) {
            String clientIp = request.getServerName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("redirectUser request IP:" + clientIp));
            }
            try {
                if (clientIp.contains(".")) {
                    clientIp = clientIp.substring(0, clientIp.indexOf(".", clientIp.indexOf(".") + 1));
                }
            }
            catch (Exception e1) {
                logger.warn((Object)"sub client IP err:", (Throwable)e1);
            }
            Set urls = StringUtils.commaDelimitedListToSet((String)this.publicOauth);
            for (String url : urls) {
                if (StringUtils.isEmpty((Object)clientIp) || !url.contains(clientIp)) continue;
                redirectUri = url;
                break;
            }
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)redirectUri);
        Map requestParams = e.getRequestParams();
        for (Map.Entry param : requestParams.entrySet()) {
            builder.queryParam((String)param.getKey(), new Object[]{param.getValue()});
        }
        if (e.getStateKey() != null) {
            builder.queryParam("state", new Object[]{e.getStateKey()});
        }
        this.redirectStrategy.sendRedirect(request, response, builder.build().encode().toUriString());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }
}

