/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config.handler;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.UrlUtils;

public class GtmapAccessDeniedHandler
implements AccessDeniedHandler {
    private static final Log logger = LogFactory.getLog(GtmapAccessDeniedHandler.class);
    private String errorPage;

    public String getErrorPage() {
        return this.errorPage;
    }

    public GtmapAccessDeniedHandler setErrorPage(String errorPage) {
        this.errorPage = errorPage;
        return this;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        boolean isAjax = ClientIpUtils.isAjaxRequest((HttpServletRequest)request);
        if (!response.isCommitted()) {
            if (isAjax) {
                String msg = accessDeniedException.getMessage();
                logger.debug((Object)"accessDeniedException.message = ".concat(msg));
                HashMap errMap = Maps.newHashMap();
                errMap.put("code", 401);
                errMap.put("msg", "\u4f1a\u8bdd\u5931\u6548\u6216\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
                errMap.put("detail", msg);
                this.print(response, ObjectMapperUtils.toJson((Object)errMap));
            } else if (this.errorPage != null) {
                request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
                response.setStatus(HttpStatus.FORBIDDEN.value());
                String redirectUrl = this.calculateRedirectUrl(request.getContextPath(), this.errorPage);
                redirectUrl = response.encodeRedirectURL(redirectUrl);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Redirecting to '" + redirectUrl + "'"));
                }
                response.sendRedirect(redirectUrl);
            }
        }
    }

    private String calculateRedirectUrl(String contextPath, String url) {
        if (UrlUtils.isAbsoluteUrl((String)url)) {
            return url;
        }
        return contextPath + url;
    }

    private void print(HttpServletResponse response, String msgJson) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.append(msgJson);
        out.flush();
    }
}

