/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.common.properties.security.AppSecurity;
import cn.gtmap.gtc.starter.gscas.config.handler.GtmapFilterSecurityInterceptor;
import cn.gtmap.gtc.starter.gscas.expression.GtAccessDecisionManager;
import cn.gtmap.gtc.starter.gscas.expression.GtOAuth2WebSecurityExpressionHandler;
import cn.gtmap.gtc.starter.gscas.expression.GtWebExpressionVoter;
import cn.gtmap.gtc.starter.gscas.expression.GtmapFilterInvocationSecurityMetadataSource;
import cn.gtmap.gtc.starter.gscas.property.audit.AuditLogProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2SsoProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableResourceServer
@Order(value=0x7FFFFFFA)
public class ResourceSecurityConfiguration
extends ResourceServerConfigurerAdapter {
    final Logger logger = LoggerFactory.getLogger(ResourceSecurityConfiguration.class);
    final ApplicationContext applicationContext;
    final OAuth2SsoProperties sso;
    final AppSecurity appSecurity;
    final OAuth2ProtectedResourceDetails details;
    final AuditLogProperties log;
    private DiscoveryClient discoveryClient;

    public ResourceSecurityConfiguration(ApplicationContext applicationContext, OAuth2SsoProperties sso, AppSecurity appSecurity, OAuth2ProtectedResourceDetails details, AuditLogProperties log, DiscoveryClient discoveryClient) {
        this.applicationContext = applicationContext;
        this.sso = sso;
        this.appSecurity = appSecurity;
        this.details = details;
        this.log = log;
        this.discoveryClient = discoveryClient;
    }

    public GtOAuth2WebSecurityExpressionHandler oAuth2WebSecurityExpressionHandler() {
        return new GtOAuth2WebSecurityExpressionHandler(this.applicationContext, this.appSecurity.getModuleAuthPath(), this.details.getClientId(), this.discoveryClient);
    }

    public GtWebExpressionVoter webExpressionVoter() {
        GtWebExpressionVoter webExpressionVoter = new GtWebExpressionVoter();
        webExpressionVoter.setDiscoveryClient(this.discoveryClient);
        webExpressionVoter.setExpressionHandler(this.oAuth2WebSecurityExpressionHandler());
        return webExpressionVoter;
    }

    public AccessDecisionManager accessDecisionManager() {
        ArrayList<AccessDecisionVoter<? extends Object>> decisionVoters = new ArrayList<AccessDecisionVoter<? extends Object>>();
        decisionVoters.add(this.webExpressionVoter());
        return new GtAccessDecisionManager(decisionVoters);
    }

    private GtmapFilterSecurityInterceptor createFilterSecurityInterceptor() throws Exception {
        GtmapFilterSecurityInterceptor securityInterceptor = new GtmapFilterSecurityInterceptor();
        securityInterceptor.setSecurityMetadataSource(this.gtmapFilterInvocationSecurityMetadataSource());
        securityInterceptor.setAccessDecisionManager(this.accessDecisionManager());
        return securityInterceptor;
    }

    public GtmapFilterInvocationSecurityMetadataSource gtmapFilterInvocationSecurityMetadataSource() {
        return new GtmapFilterInvocationSecurityMetadataSource();
    }

    public void configure(HttpSecurity http) throws Exception {
        GtmapFilterSecurityInterceptor filterSecurityInterceptor = this.createFilterSecurityInterceptor();
        filterSecurityInterceptor.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        http.addFilterBefore((Filter)filterSecurityInterceptor, FilterSecurityInterceptor.class);
        if (!CollectionUtils.isEmpty((Map)this.appSecurity.getResources())) {
            LinkedList<Object> urls = new LinkedList<Object>();
            for (Map.Entry entry : this.appSecurity.getResources().entrySet()) {
                urls.addAll(Arrays.asList((Object[])entry.getValue()));
            }
            if (!CollectionUtils.isEmpty(urls)) {
                String[] arr = new String[urls.size()];
                arr = urls.toArray(arr);
                GtmapFilterInvocationSecurityMetadataSource.localScopes = arr;
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers(arr)).and().authorizeRequests().anyRequest()).authenticated();
            }
        }
    }
}

