/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.common.properties.security.AppSecurity;
import cn.gtmap.gtc.starter.gcas.domain.SecurityMetaUrlSource;
import cn.gtmap.gtc.starter.gcas.util.HttpUtils;
import cn.gtmap.gtc.starter.gscas.expression.GtmapFilterInvocationSecurityMetadataSource;
import cn.gtmap.gtc.starter.gscas.expression.SecurityUrlConfig;
import cn.gtmap.gtc.starter.gscas.token.TokenDataRepo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsUtils;

@Configuration
public class InitSecurityCfgThreadConfig {
    private static final RequestMatcher ANY_REQUEST = AnyRequestMatcher.INSTANCE;
    private static int start = 0;
    final String clientId;
    final String clientSecret;
    final DiscoveryClient discoveryClient;
    private final Logger logger = LoggerFactory.getLogger(InitSecurityCfgThreadConfig.class);

    public InitSecurityCfgThreadConfig(OAuth2ProtectedResourceDetails details, DiscoveryClient discoveryClient, AppSecurity appSecurity) {
        this.discoveryClient = discoveryClient;
        this.clientId = details.getClientId();
        this.clientSecret = details.getClientSecret();
        for (Map.Entry entry : appSecurity.getAuthorities().entrySet()) {
            if (!"authenticated".equalsIgnoreCase((String)entry.getKey()) || !"false".equals(((String[])entry.getValue())[0])) continue;
            GtmapFilterInvocationSecurityMetadataSource.localAuthenticated = false;
            break;
        }
        this.saveRequestMap(null);
    }

    private String getAccountUrl() {
        String url = null;
        List instances = this.discoveryClient.getInstances("account");
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            Random random = new Random();
            int n = random.nextInt(instances.size());
            ServiceInstance serviceInstance = (ServiceInstance)instances.get(n);
            url = serviceInstance.getHost() + ":" + serviceInstance.getPort();
        }
        return url;
    }

    @Scheduled(cron="0 */6 * * * ?")
    public void accessInitClientToken() {
        try {
            String authUrl = this.getAccountUrl();
            if (!StringUtils.isEmpty((Object)authUrl)) {
                StringBuilder builder = new StringBuilder(authUrl);
                builder.append("/account/oauth/token?grant_type=client_credentials&client_id=").append(this.clientId).append("&client_secret=").append(this.clientSecret);
                String res = HttpUtils.get((String)builder.toString(), null, null);
                if (!StringUtils.isEmpty((Object)res)) {
                    JSONObject object = JSON.parseObject((String)res);
                    Map map = object.getInnerMap();
                    if (map != null && null != map.get("access_token")) {
                        String accessToken = (String)map.get("access_token");
                        int expires = (Integer)map.get("expires_in");
                        int time = (int)(System.currentTimeMillis() / 1000L) + (expires -= 100);
                        TokenDataRepo.getInstance().updateToken(accessToken, time);
                        this.logger.info("init client token: {} expires:{}", (Object)accessToken, (Object)expires);
                    }
                } else {
                    this.logger.error("getNewAccessToken: {}", (Object)res);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("getNewAccessToken", (Throwable)e);
        }
    }

    @Scheduled(cron="0 */4 * * * ?")
    public void accessInit() {
        try {
            List instances = this.discoveryClient.getInstances("account");
            if (!CollectionUtils.isEmpty((Collection)instances)) {
                List sources;
                Random random = new Random();
                int n = random.nextInt(instances.size());
                ServiceInstance serviceInstance = (ServiceInstance)instances.get(n);
                String ipaAndPort = serviceInstance.getHost() + ":" + serviceInstance.getPort();
                String requestUrl = "http://".concat(ipaAndPort).concat("/account/auth/client/access/config");
                HashMap<String, String> query = new HashMap<String, String>();
                query.put("clientId", this.clientId);
                String string = HttpUtils.get((String)requestUrl, query, null);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("clientUrlConfig: " + string);
                }
                if (!CollectionUtils.isEmpty((Collection)(sources = JSON.parseArray((String)string, SecurityMetaUrlSource.class)))) {
                    LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
                    requestMap.put(CorsUtils::isPreFlightRequest, SecurityUrlConfig.createList(null, "permitAll"));
                    for (SecurityMetaUrlSource securityMetaUrlSource : sources) {
                        try {
                            String[] array;
                            if ("UNLIMITED".equals(securityMetaUrlSource.getType())) {
                                requestMap.put((RequestMatcher)new AntPathRequestMatcher(securityMetaUrlSource.getUrl(), null), SecurityUrlConfig.createList(securityMetaUrlSource.getDatas(), "permitAll"));
                                continue;
                            }
                            if ("HAS_SCOPE".equals(securityMetaUrlSource.getType())) {
                                array = new String[securityMetaUrlSource.getAuthorities().size()];
                                array = securityMetaUrlSource.getAuthorities().toArray(array);
                                requestMap.put((RequestMatcher)new AntPathRequestMatcher(securityMetaUrlSource.getUrl(), securityMetaUrlSource.getMethod()), SecurityUrlConfig.createList(securityMetaUrlSource.getDatas(), InitSecurityCfgThreadConfig.hasAnyScope(array)));
                                continue;
                            }
                            if ("HAS_ROLE".equals(securityMetaUrlSource.getType()) || "HAS_ORG".equals(securityMetaUrlSource.getType())) {
                                array = new String[securityMetaUrlSource.getAuthorities().size()];
                                array = securityMetaUrlSource.getAuthorities().toArray(array);
                                requestMap.put((RequestMatcher)new AntPathRequestMatcher(securityMetaUrlSource.getUrl(), securityMetaUrlSource.getMethod()), SecurityUrlConfig.createList(securityMetaUrlSource.getDatas(), InitSecurityCfgThreadConfig.hasAnyAuthority(array)));
                                continue;
                            }
                            if ("HAS_IP".equals(securityMetaUrlSource.getType())) {
                                array = new String[securityMetaUrlSource.getAuthorities().size()];
                                array = securityMetaUrlSource.getAuthorities().toArray(array);
                                requestMap.put((RequestMatcher)new AntPathRequestMatcher(securityMetaUrlSource.getUrl(), securityMetaUrlSource.getMethod()), SecurityUrlConfig.createList(securityMetaUrlSource.getDatas(), InitSecurityCfgThreadConfig.hasAnyIpAddress(array)));
                                continue;
                            }
                            if ("HAS_AUTHENTICATED".equals(securityMetaUrlSource.getType())) {
                                if (!GtmapFilterInvocationSecurityMetadataSource.localAuthenticated) continue;
                                requestMap.put((RequestMatcher)new AntPathRequestMatcher(securityMetaUrlSource.getUrl(), null), SecurityUrlConfig.createList(securityMetaUrlSource.getDatas(), "authenticated"));
                                continue;
                            }
                            if (!"DENY".equals(securityMetaUrlSource.getType()) || !GtmapFilterInvocationSecurityMetadataSource.localAuthenticated) continue;
                            requestMap.put((RequestMatcher)new AntPathRequestMatcher(securityMetaUrlSource.getUrl(), null), SecurityUrlConfig.createList(securityMetaUrlSource.getDatas(), "denyAll"));
                        }
                        catch (Exception e) {
                            this.logger.warn("build PathRequestMatcher error:", (Throwable)e);
                        }
                    }
                    this.saveRequestMap(requestMap);
                } else {
                    this.saveRequestMap(null);
                }
            } else {
                this.saveRequestMap(null);
            }
        }
        catch (Exception e) {
            this.logger.warn("AccessInitRunnable", (Throwable)e);
            this.saveRequestMap(null);
        }
    }

    private void saveRequestMap(Map<RequestMatcher, Collection<ConfigAttribute>> requestMap) {
        if (CollectionUtils.isEmpty(requestMap)) {
            if (start == 0) {
                requestMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
                requestMap.put(CorsUtils::isPreFlightRequest, SecurityUrlConfig.createList(null, "permitAll"));
                if (GtmapFilterInvocationSecurityMetadataSource.localScopes != null) {
                    for (String s : GtmapFilterInvocationSecurityMetadataSource.localScopes) {
                        requestMap.put((RequestMatcher)new AntPathRequestMatcher(s, null), SecurityUrlConfig.createList(null, "authenticated"));
                    }
                }
                if (GtmapFilterInvocationSecurityMetadataSource.localAuthenticated) {
                    requestMap.put((RequestMatcher)new AntPathRequestMatcher("/**", null), SecurityUrlConfig.createList(null, "authenticated"));
                } else {
                    requestMap.put((RequestMatcher)new AntPathRequestMatcher("/**", null), SecurityUrlConfig.createList(null, "permitAll"));
                }
                GtmapFilterInvocationSecurityMetadataSource.setRequestMap(requestMap);
                start = 1;
                this.logger.warn("init security config settings!!!");
            }
        } else {
            GtmapFilterInvocationSecurityMetadataSource.setRequestMap(requestMap);
        }
    }

    private static String hasAnyAuthority(String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','");
        return "hasAnyAuthority('" + anyAuthorities + "')";
    }

    private static String hasAnyScope(String ... scopes) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])scopes, (String)"','");
        return "#oauth2.hasAnyScope('" + anyAuthorities + "')";
    }

    private static String hasAnyIpAddress(String ... ipAddressExpression) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])ipAddressExpression, (String)"','");
        return "hasAnyIpAddress('" + anyAuthorities + "')";
    }
}

