/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.expression;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GtWebSecurityExpressionRoot
extends WebSecurityExpressionRoot {
    protected final Log logger = LogFactory.getLog(GtWebSecurityExpressionRoot.class);
    private OAuth2RestTemplate template;
    private String username;
    private String requestPath;
    private String url;
    private String clientId;
    private String method;

    public GtWebSecurityExpressionRoot(Authentication a, FilterInvocation fi, OAuth2RestTemplate template, String authPath, String clientId) {
        super(a, fi);
        this.username = a.getName();
        this.template = template;
        this.clientId = clientId;
        this.url = authPath != null && authPath.lastIndexOf("/") != authPath.length() - 1 ? authPath + "/" : authPath;
        StringBuilder path = new StringBuilder();
        if (fi.getHttpRequest().getServletPath() != null) {
            path.append(fi.getHttpRequest().getServletPath());
            if (fi.getHttpRequest().getPathInfo() != null) {
                path.append(fi.getHttpRequest().getPathInfo());
            }
        }
        this.method = fi.getHttpRequest().getMethod();
        this.requestPath = path.toString();
    }

    public boolean hasModuleAuthority(String authority) {
        if ("anonymousUser".equals(this.username)) {
            return this.hasAnyAuthority(new String[]{authority});
        }
        return this.moduleAuth(authority);
    }

    public boolean hasUrlAuthority(String authority) {
        if ("anonymousUser".equals(this.username)) {
            return this.hasAnyAuthority(new String[]{authority});
        }
        return this.urlAuth(authority);
    }

    public boolean hasAnyUrlAuthority(String ... authorities) {
        if ("anonymousUser".equals(this.username)) {
            return this.hasAnyAuthority(authorities);
        }
        if (authorities.length == 0) {
            return this.urlAuth("");
        }
        for (String authority : authorities) {
            if (!this.urlAuth(authority)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyModuleAuthority(String ... authorities) {
        if ("anonymousUser".equals(this.username)) {
            return this.hasAnyAuthority(authorities);
        }
        for (String authority : authorities) {
            if (!this.moduleAuth(authority)) continue;
            return true;
        }
        return false;
    }

    private boolean urlAuth(String authority) {
        if (null == this.template || null == this.url) {
            return false;
        }
        StringBuilder builder = new StringBuilder(this.url);
        builder.append("auth/menu/url-authority?username=").append(this.username).append("&path=").append(this.requestPath).append("&clientId=").append(this.clientId).append("&method=").append(this.method);
        Map authorityCode = (Map)this.template.getForObject(builder.toString(), Map.class, new Object[0]);
        if (CollectionUtils.isEmpty((Map)authorityCode)) {
            return false;
        }
        return this.verifyAuthority(authority, authorityCode);
    }

    private boolean moduleAuth(String authority) {
        Map authorityCode;
        if (null == this.template || null == this.url) {
            return false;
        }
        String[] args = authority.split(":");
        if (args.length < 1) {
            return false;
        }
        String moduleCode = args[0];
        String optStr = "";
        if (args.length > 1) {
            optStr = args[1];
        }
        if (CollectionUtils.isEmpty((Map)(authorityCode = (Map)this.template.getForObject(this.url + "auth/menu/module-authority?username=" + this.username + "&moduleCode=" + moduleCode + "&clientId=" + this.clientId, Map.class, new Object[0])))) {
            return false;
        }
        return this.verifyAuthority(optStr, authorityCode);
    }

    private boolean verifyAuthority(String optStr, Map<String, String> authority) {
        if (!StringUtils.isEmpty((Object)authority.get("root"))) {
            if ("all:all".equals(authority.get("root"))) {
                this.request.setAttribute("currentAuthority", (Object)authority.get("root"));
                this.request.setAttribute("elementAuthorities", (Object)authority.get("elements"));
                return true;
            }
            Set opts = StringUtils.commaDelimitedListToSet((String)optStr);
            if (!CollectionUtils.isEmpty((Collection)opts)) {
                for (String opt : opts) {
                    if (authority.get("root").contains(opt)) continue;
                    return false;
                }
            }
            this.request.setAttribute("currentAuthority", (Object)authority.get("root"));
            this.request.setAttribute("elementAuthorities", (Object)authority.get("elements"));
            return true;
        }
        return false;
    }
}

