/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.expression;

import java.util.Collection;
import java.util.List;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;

public class GtAccessDecisionManager
extends AbstractAccessDecisionManager {
    public GtAccessDecisionManager(List<AccessDecisionVoter<? extends Object>> decisionVoters) {
        super(decisionVoters);
    }

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        if (configAttributes == null) {
            throw new AccessDeniedException("Access is denied");
        }
        int deny = 0;
        for (AccessDecisionVoter voter : this.getDecisionVoters()) {
            int result = voter.vote(authentication, object, configAttributes);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Voter: " + voter + ", returned: " + result));
            }
            switch (result) {
                case 1: {
                    return;
                }
                case -1: {
                    ++deny;
                    break;
                }
            }
        }
        if (deny > 0) {
            throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
        }
        this.checkAllowIfAllAbstainDecisions();
    }

    public boolean supports(ConfigAttribute attribute) {
        return false;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

