/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.common.properties.security.AppSecurity;
import cn.gtmap.gtc.starter.gscas.config.GtmapSessionInformationExpiredStrategy;
import cn.gtmap.gtc.starter.gscas.config.GtmapSessionRegistryImpl;
import cn.gtmap.gtc.starter.gscas.config.OAuth2SsoCustomConfiguration;
import cn.gtmap.gtc.starter.gscas.config.SsoSecurityConfigurer;
import cn.gtmap.gtc.starter.gscas.expression.GtAccessDecisionManager;
import cn.gtmap.gtc.starter.gscas.expression.GtWebSecurityExpressionHandler;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2SsoProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.web.access.expression.WebExpressionVoter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;

@Configuration
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Order(value=0x7FFFFFF8)
@AutoConfigureBefore(value={OAuth2SsoCustomConfiguration.class})
public class SsoWebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    final Logger logger = LoggerFactory.getLogger(SsoWebSecurityConfiguration.class);
    final ApplicationContext applicationContext;
    final OAuth2SsoProperties sso;
    final AppSecurity appSecurity;
    final OAuth2ProtectedResourceDetails details;

    public SsoWebSecurityConfiguration(ApplicationContext applicationContext, OAuth2SsoProperties sso, AppSecurity appSecurity, OAuth2ProtectedResourceDetails details) {
        this.applicationContext = applicationContext;
        this.sso = sso;
        this.appSecurity = appSecurity;
        this.details = details;
    }

    public GtWebSecurityExpressionHandler webSecurityExpressionHandler() {
        GtWebSecurityExpressionHandler webSecurityExpressionHandler = new GtWebSecurityExpressionHandler(super.getApplicationContext(), this.appSecurity.getModuleAuthPath(), this.details.getClientId());
        return webSecurityExpressionHandler;
    }

    public WebExpressionVoter webExpressionVoter() {
        WebExpressionVoter webExpressionVoter = new WebExpressionVoter();
        webExpressionVoter.setExpressionHandler((SecurityExpressionHandler)this.webSecurityExpressionHandler());
        return webExpressionVoter;
    }

    public AccessDecisionManager accessDecisionManager() {
        ArrayList<AccessDecisionVoter<? extends Object>> decisionVoters = new ArrayList<AccessDecisionVoter<? extends Object>>();
        decisionVoters.add((AccessDecisionVoter<? extends Object>)this.webExpressionVoter());
        GtAccessDecisionManager accessDecisionManager = new GtAccessDecisionManager(decisionVoters);
        return accessDecisionManager;
    }

    protected void configure(HttpSecurity http) throws Exception {
        boolean anyAuthenticated = false;
        for (Map.Entry entry : this.appSecurity.getAuthorities().entrySet()) {
            try {
                if (entry.getKey() == "permitAll") {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers((String[])entry.getValue())).permitAll().and();
                    continue;
                }
                if ("authenticated".equals(entry.getKey())) {
                    for (String value : (String[])entry.getValue()) {
                        if (!"true".equals(value)) continue;
                        anyAuthenticated = true;
                        break;
                    }
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers((String[])entry.getValue())).authenticated().and();
                    continue;
                }
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers((String[])entry.getValue())).access((String)entry.getKey()).and();
            }
            catch (Exception e) {
                this.logger.error("app.security.authorities has wrong key or values [{}]", (Object)e.getLocalizedMessage());
            }
        }
        if (anyAuthenticated) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        }
        http.authorizeRequests().withObjectPostProcessor((ObjectPostProcessor)new ObjectPostProcessor<FilterSecurityInterceptor>(){

            public <O extends FilterSecurityInterceptor> O postProcess(O fsi) {
                fsi.setAccessDecisionManager(SsoWebSecurityConfiguration.this.accessDecisionManager());
                fsi.setPublishAuthorizationSuccess(true);
                return fsi;
            }
        });
        ((HttpSecurity)http.csrf().disable()).headers().contentTypeOptions().disable().frameOptions().disable().cacheControl().disable();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).maximumSessions(-1).expiredSessionStrategy((SessionInformationExpiredStrategy)new GtmapSessionInformationExpiredStrategy()).sessionRegistry(this.sessionRegistry());
        new SsoSecurityConfigurer(this.applicationContext).configure(http);
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        return new GtmapSessionRegistryImpl();
    }

    public void configure(WebSecurity web) throws Exception {
        try {
            web.ignoring().antMatchers(this.appSecurity.getIgnores());
        }
        catch (Exception e) {
            this.logger.error("app.security.ignores has wrong values [{}]", (Object)e.getLocalizedMessage());
        }
    }
}

