/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.common.properties.security.AppSecurity;
import cn.gtmap.gtc.starter.gscas.annotation.ModuleAuthorityAspect;
import cn.gtmap.gtc.starter.gscas.config.OAuth2FeignRequestInterceptor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;

@Configuration
public class SecurityAutoConfiguration {
    final ApplicationContext applicationContext;
    final AppSecurity appSecurity;
    final OAuth2ProtectedResourceDetails details;

    public SecurityAutoConfiguration(ApplicationContext applicationContext, AppSecurity appSecurity, OAuth2ProtectedResourceDetails details) {
        this.applicationContext = applicationContext;
        this.appSecurity = appSecurity;
        this.details = details;
    }

    @Bean
    public OAuth2FeignRequestInterceptor oAuth2FeignRequestInterceptor(OAuth2ClientContext oAuth2ClientContext, OAuth2ProtectedResourceDetails resource) {
        return new OAuth2FeignRequestInterceptor(oAuth2ClientContext, resource);
    }

    @Bean
    public ModuleAuthorityAspect authorityActuatorAspect() {
        return new ModuleAuthorityAspect(this.applicationContext, this.details.getClientId(), this.appSecurity.getModuleAuthPath());
    }
}

