/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.starter.gscas.annotation.LogAspect;
import cn.gtmap.gtc.starter.gscas.audit.AuthenticationAuditListener;
import cn.gtmap.gtc.starter.gscas.audit.AuthorizationAuditListener;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.listener.AbstractAuditListener;
import org.springframework.boot.actuate.audit.listener.AuditListener;
import org.springframework.boot.actuate.security.AbstractAuthenticationAuditListener;
import org.springframework.boot.actuate.security.AbstractAuthorizationAuditListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
public class SecurityAuditConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AuditEventRepository.class})
    ZipkinAuditEventRepository zipkinAuditEventRepository(Tracer tracer) {
        return new ZipkinAuditEventRepository(tracer);
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractAuditListener.class})
    public AuditListener auditListener(Tracer tracer) throws Exception {
        return new AuditListener((AuditEventRepository)this.zipkinAuditEventRepository(tracer));
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.authentication.event.AbstractAuthenticationEvent"})
    @ConditionalOnMissingBean(value={AbstractAuthenticationAuditListener.class})
    public AuthenticationAuditListener authenticationAuditListener() throws Exception {
        return new AuthenticationAuditListener();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.access.event.AbstractAuthorizationEvent"})
    @ConditionalOnMissingBean(value={AbstractAuthorizationAuditListener.class})
    public AuthorizationAuditListener authorizationAuditListener() throws Exception {
        return new AuthorizationAuditListener();
    }

    @Bean
    public LogAspect auditLogAspect() {
        LogAspect auditLogAspect = new LogAspect();
        return auditLogAspect;
    }
}

