/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import cn.gtmap.gtc.common.properties.security.AppSecurity;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;

@Configuration
@EnableResourceServer
@Order(value=0x7FFFFFFA)
public class ResourceSecurityConfiguration
extends ResourceServerConfigurerAdapter {
    final Logger logger = LoggerFactory.getLogger(ResourceSecurityConfiguration.class);
    final AppSecurity appSecurity;

    public ResourceSecurityConfiguration(AppSecurity appSecurity) {
        this.appSecurity = appSecurity;
    }

    public void configure(HttpSecurity http) throws Exception {
        for (Map.Entry entry : this.appSecurity.getResources().entrySet()) {
            try {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers((String[])entry.getValue())).and().authorizeRequests().anyRequest()).access("#oauth2.".concat((String)entry.getKey()));
            }
            catch (Exception e) {
                this.logger.error("app.security.resources has wrong key or values [{}]", (Object)e.getLocalizedMessage());
            }
        }
    }
}

