/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.session.SessionDestroyedEvent;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.util.Assert;

public class GtmapSessionRegistryImpl
implements SessionRegistry,
ApplicationListener<SessionDestroyedEvent> {
    @Resource
    private RedisTemplate redisTemplate;
    private static final String SESSIONIDS = "sessionIds";
    private static final String PRINCIPALS = "principals";
    protected final Log logger = LogFactory.getLog(GtmapSessionRegistryImpl.class);

    public List<Object> getAllPrincipals() {
        return new ArrayList<Object>(this.getPrincipalsKeySet());
    }

    public List<SessionInformation> getAllSessions(Object principal, boolean includeExpiredSessions) {
        Set<String> sessionsUsedByPrincipal = this.getPrincipals("USER_CLIENT_" + (String)principal);
        if (sessionsUsedByPrincipal == null) {
            return Collections.emptyList();
        }
        ArrayList<SessionInformation> list = new ArrayList<SessionInformation>(sessionsUsedByPrincipal.size());
        Iterator<String> var5 = sessionsUsedByPrincipal.iterator();
        while (var5.hasNext()) {
            String sessionId = var5.next();
            SessionInformation sessionInformation = this.getSessionInformation(sessionId);
            if (sessionInformation == null || !includeExpiredSessions && sessionInformation.isExpired()) continue;
            list.add(sessionInformation);
        }
        return list;
    }

    public SessionInformation getSessionInformation(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        return this.getSessionInfo(sessionId);
    }

    public void onApplicationEvent(SessionDestroyedEvent event) {
        String sessionId = event.getId();
        this.removeSessionInformation(sessionId);
    }

    public void refreshLastRequest(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        SessionInformation info = this.getSessionInformation(sessionId);
        if (info != null) {
            info.refreshLastRequest();
        }
    }

    public void registerNewSession(String sessionId, Object principal) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        Assert.notNull((Object)principal, (String)"Principal required as per interface contract");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering session " + sessionId + ", for principal " + principal));
        }
        if (this.getSessionInformation(sessionId) != null) {
            this.removeSessionInformation(sessionId);
        }
        this.addSessionInfo(sessionId, new SessionInformation(principal, sessionId, new Date()));
        Set<String> sessionsUsedByPrincipal = this.getPrincipals("USER_CLIENT_" + principal.toString());
        if (sessionsUsedByPrincipal == null) {
            sessionsUsedByPrincipal = new CopyOnWriteArraySet<String>();
            Set<String> prevSessionsUsedByPrincipal = this.putIfAbsentPrincipals("USER_CLIENT_" + principal.toString(), sessionsUsedByPrincipal);
            if (prevSessionsUsedByPrincipal != null) {
                sessionsUsedByPrincipal = prevSessionsUsedByPrincipal;
            }
        }
        sessionsUsedByPrincipal.add(sessionId);
        this.putPrincipals("USER_CLIENT_" + principal.toString(), sessionsUsedByPrincipal);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Sessions used by '" + principal + "' : " + sessionsUsedByPrincipal));
        }
    }

    public void removeSessionInformation(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        SessionInformation info = this.getSessionInformation(sessionId);
        if (info != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.debug((Object)("Removing session " + sessionId + " from set of registered sessions"));
            }
            this.removeSessionInfo(sessionId);
            Set<String> sessionsUsedByPrincipal = this.getPrincipals("USER_CLIENT_" + info.getPrincipal().toString());
            if (sessionsUsedByPrincipal != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Removing session " + sessionId + " from principal's set of registered sessions"));
                }
                sessionsUsedByPrincipal.remove(sessionId);
                if (sessionsUsedByPrincipal.isEmpty()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Removing principal " + info.getPrincipal() + " from registry"));
                    }
                    this.removePrincipal("USER_CLIENT_" + info.getPrincipal().toString());
                } else {
                    this.putPrincipals("USER_CLIENT_" + info.getPrincipal().toString(), sessionsUsedByPrincipal);
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Sessions used by '" + info.getPrincipal() + "' : " + sessionsUsedByPrincipal));
                }
            }
        }
    }

    public void addSessionInfo(String sessionId, SessionInformation sessionInformation) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps((Object)SESSIONIDS);
        hashOperations.put((Object)sessionId, (Object)sessionInformation);
    }

    public SessionInformation getSessionInfo(String sessionId) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps((Object)SESSIONIDS);
        return (SessionInformation)hashOperations.get((Object)sessionId);
    }

    public void removeSessionInfo(String sessionId) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps((Object)SESSIONIDS);
        hashOperations.delete(new Object[]{sessionId});
    }

    public Set<String> putIfAbsentPrincipals(String key, Set<String> set) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps((Object)PRINCIPALS);
        hashOperations.putIfAbsent((Object)key, set);
        return (Set)hashOperations.get((Object)key);
    }

    public void putPrincipals(String key, Set<String> set) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps((Object)PRINCIPALS);
        hashOperations.put((Object)key, set);
    }

    public Set<String> getPrincipals(String key) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps((Object)PRINCIPALS);
        return (Set)hashOperations.get((Object)key);
    }

    public Set<String> getPrincipalsKeySet() {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps((Object)PRINCIPALS);
        return hashOperations.keys();
    }

    public void removePrincipal(String key) {
        BoundHashOperations hashOperations = this.redisTemplate.boundHashOps((Object)PRINCIPALS);
        hashOperations.delete(new Object[]{key});
    }
}

