/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.util.Assert;

public class ZipkinAuditEventRepository
implements AuditEventRepository {
    private static ObjectMapper mapper = new ObjectMapper();
    Tracer tracer;

    public ZipkinAuditEventRepository(Tracer tracer) {
        this.tracer = tracer;
    }

    public void add(AuditEvent event) {
        Assert.notNull((Object)event, (String)"AuditEvent must not be null");
        this.addSpanTag(event);
    }

    private void addSpanTag(AuditEvent event) {
        try {
            if (null != this.tracer) {
                String point = this.tracer.getCurrentSpan().getName();
                if (point.contains(".js") || point.contains(".png") || point.contains(".css") || point.contains(".woff") || point.contains(".font") || point.contains(".gif") || point.contains(".eot") || point.contains(".ttf")) {
                    return;
                }
                this.tracer.addTag("principal", event.getPrincipal());
                this.tracer.addTag("event", event.getType());
                this.tracer.addTag(event.getType(), event.getPrincipal());
                Map data = event.getData();
                if (null != data) {
                    for (Map.Entry entry : data.entrySet()) {
                        this.tracer.addTag((String)entry.getKey(), this.buildValue(entry.getValue()));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<AuditEvent> find(Date after) {
        return this.find(null, after, null);
    }

    public List<AuditEvent> find(String principal, Date after) {
        return this.find(principal, after, null);
    }

    public List<AuditEvent> find(String principal, Date after, String type) {
        LinkedList<AuditEvent> events = new LinkedList<AuditEvent>();
        return events;
    }

    public String buildValue(Object arg) {
        String className;
        if (null == arg) {
            return "unknown";
        }
        switch (className = arg.getClass().getName()) {
            case "java.lang.String": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Short": 
            case "java.lang.Byte": {
                return arg.toString();
            }
        }
        try {
            return mapper.writeValueAsString(arg);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "unknown";
        }
    }
}

