/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.security.AbstractAuthorizationAuditListener;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.event.AbstractAuthorizationEvent;
import org.springframework.security.access.event.AuthenticationCredentialsNotFoundEvent;
import org.springframework.security.access.event.AuthorizationFailureEvent;
import org.springframework.security.access.event.AuthorizedEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;

public class AuthorizationAuditListener
extends AbstractAuthorizationAuditListener {
    public static final String AUTHORIZATION_FAILURE = "AUTHORIZATION_FAILURE";
    public static final String AUTHORIZATION_SUCCESS = "AUTHORIZATION_SUCCESS";

    public void onApplicationEvent(AbstractAuthorizationEvent event) {
        if (event instanceof AuthenticationCredentialsNotFoundEvent) {
            this.onAuthenticationCredentialsNotFoundEvent((AuthenticationCredentialsNotFoundEvent)event);
        } else if (event instanceof AuthorizationFailureEvent) {
            this.onAuthorizationFailureEvent((AuthorizationFailureEvent)event);
        } else if (event instanceof AuthorizedEvent) {
            this.onAuthorizationSuccessEvent((AuthorizedEvent)event);
        }
    }

    private void onAuthorizationSuccessEvent(AuthorizedEvent event) {
        Authentication authentication = event.getAuthentication();
        if (authentication != null) {
            String principal = "unknown";
            if (authentication.getName() != null) {
                principal = authentication.getName();
            } else if (authentication.getPrincipal() != null && authentication.getPrincipal() instanceof UserDetails) {
                principal = ((UserDetails)authentication.getPrincipal()).getUsername();
            }
            if ("anonymousUser".equals(principal)) {
                return;
            }
            HashMap<String, List<String>> data = new HashMap<String, List<String>>();
            data.put("attributes", this.getAttributeList(event.getConfigAttributes()));
            this.publish(new AuditEvent(principal, AUTHORIZATION_SUCCESS, data));
        }
    }

    private void onAuthenticationCredentialsNotFoundEvent(AuthenticationCredentialsNotFoundEvent event) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("exception", event.getCredentialsNotFoundException().getClass().getName());
        data.put("message", event.getCredentialsNotFoundException().getMessage());
        data.put("attributes", this.getAttributeList(event.getConfigAttributes()));
        this.publish(new AuditEvent("unknown", "AUTHENTICATION_FAILURE", data));
    }

    private List<String> getAttributeList(Collection<ConfigAttribute> attributes) {
        ArrayList<String> attributeList = new ArrayList<String>();
        attributes.stream().forEach(attribute -> attributeList.add(attribute.toString().replace("'", "")));
        return attributeList;
    }

    private void onAuthorizationFailureEvent(AuthorizationFailureEvent event) {
        if ("anonymousUser".equals(event.getAuthentication().getName())) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("exception", event.getAccessDeniedException().getClass().getName());
        data.put("message", event.getAccessDeniedException().getMessage());
        if (event.getAuthentication().getDetails() != null) {
            data.put("details", event.getAuthentication().getDetails());
        }
        data.put("attributes", this.getAttributeList(event.getConfigAttributes()));
        this.publish(new AuditEvent(event.getAuthentication().getName(), AUTHORIZATION_FAILURE, data));
    }
}

