/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.audit;

import java.util.HashMap;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.security.AbstractAuthenticationAuditListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.web.authentication.switchuser.AuthenticationSwitchUserEvent;
import org.springframework.util.ClassUtils;

public class AuthenticationAuditListener
extends AbstractAuthenticationAuditListener {
    public static final String AUTHENTICATION_SUCCESS = "AUTHENTICATION_SUCCESS";
    public static final String AUTHENTICATION_FAILURE = "AUTHENTICATION_FAILURE";
    public static final String AUTHENTICATION_SWITCH = "AUTHENTICATION_SWITCH";
    private static final String WEB_LISTENER_CHECK_CLASS = "org.springframework.security.web.authentication.switchuser.AuthenticationSwitchUserEvent";
    private WebAuditListener webListener = AuthenticationAuditListener.maybeCreateWebListener();

    private static WebAuditListener maybeCreateWebListener() {
        return ClassUtils.isPresent((String)WEB_LISTENER_CHECK_CLASS, (ClassLoader)null) ? new WebAuditListener() : null;
    }

    public void onApplicationEvent(AbstractAuthenticationEvent event) {
        if (event instanceof AbstractAuthenticationFailureEvent) {
            this.onAuthenticationFailureEvent((AbstractAuthenticationFailureEvent)event);
        } else if (this.webListener != null && this.webListener.accepts(event)) {
            this.webListener.process(this, event);
        } else if (event instanceof AuthenticationSuccessEvent) {
            this.onAuthenticationSuccessEvent((AuthenticationSuccessEvent)event);
        }
    }

    private void onAuthenticationFailureEvent(AbstractAuthenticationFailureEvent event) {
        if ("anonymousUser".equals(event.getAuthentication().getName())) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("exception", event.getException().getClass().getName());
        data.put("message", event.getException().getMessage());
        if (event.getAuthentication().getDetails() != null) {
            data.put("details", event.getAuthentication().getDetails());
        }
        this.publish(new AuditEvent(event.getAuthentication().getName(), AUTHENTICATION_FAILURE, data));
    }

    private void onAuthenticationSuccessEvent(AuthenticationSuccessEvent event) {
        if ("anonymousUser".equals(event.getAuthentication().getName())) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (event.getAuthentication().getDetails() != null) {
            data.put("details", event.getAuthentication().getDetails());
        }
        this.publish(new AuditEvent(event.getAuthentication().getName(), AUTHENTICATION_SUCCESS, data));
    }

    private static class WebAuditListener {
        private WebAuditListener() {
        }

        public void process(AuthenticationAuditListener listener, AbstractAuthenticationEvent input) {
            AuthenticationSwitchUserEvent event;
            if (listener != null && !"anonymousUser".equals((event = (AuthenticationSwitchUserEvent)input).getAuthentication().getName())) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                if (event.getAuthentication().getDetails() != null) {
                    data.put("details", event.getAuthentication().getDetails());
                }
                data.put("target", event.getTargetUser().getUsername());
                listener.publish(new AuditEvent(event.getAuthentication().getName(), AuthenticationAuditListener.AUTHENTICATION_SWITCH, data));
            }
        }

        public boolean accepts(AbstractAuthenticationEvent event) {
            return event instanceof AuthenticationSwitchUserEvent;
        }
    }
}

