/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.annotation;

import cn.gtmap.gtc.starter.gscas.annotation.ModuleAuthority;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class ModuleAuthorityAspect {
    static final Logger log = LoggerFactory.getLogger(ModuleAuthorityAspect.class);
    private OAuth2RestTemplate template;
    private String clientId;
    private String authPath;

    public ModuleAuthorityAspect(ApplicationContext applicationContext, String clientId, String authPath) {
        this.clientId = clientId;
        this.authPath = authPath != null && authPath.lastIndexOf("/") != authPath.length() - 1 ? authPath + "/" : authPath;
        this.template = ((UserInfoRestTemplateFactory)applicationContext.getBean(UserInfoRestTemplateFactory.class)).getUserInfoRestTemplate();
    }

    @Pointcut(value="@annotation(authorityActuator)")
    public void AuthorityAspect(ModuleAuthority authorityActuator) {
    }

    @Before(value="AuthorityAspect(authorityActuator)")
    public void doBefore(JoinPoint joinPoint, ModuleAuthority authorityActuator) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        if (!StringUtils.isEmpty((Object)authorityActuator.code())) {
            if (!this.isEmptyCurrentAuthority(request)) {
                String authority = (String)request.getAttribute("currentAuthority");
                String[] moduleCodeArr = authority.split(":");
                if (authorityActuator.code().equals(moduleCodeArr[0]) || "all".equals(moduleCodeArr[0])) {
                    return;
                }
            }
            this.setModuleCurrentAuthority(request, authorityActuator.code());
        } else if (!StringUtils.isEmpty((Object)authorityActuator.path())) {
            this.setUrlCurrentAuthority(request, authorityActuator.path(), authorityActuator.method());
        } else {
            if (!this.isEmptyCurrentAuthority(request)) {
                return;
            }
            StringBuilder path = new StringBuilder();
            if (request.getServletPath() != null) {
                path.append(request.getServletPath());
                if (request.getPathInfo() != null) {
                    path.append(request.getPathInfo());
                }
            }
            this.setUrlCurrentAuthority(request, path.toString(), request.getMethod());
        }
    }

    private boolean isEmptyCurrentAuthority(HttpServletRequest request) {
        return StringUtils.isEmpty((Object)request.getAttribute("currentAuthority"));
    }

    private void setModuleCurrentAuthority(HttpServletRequest request, String moduleCode) {
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            String username = SecurityContextHolder.getContext().getAuthentication().getName();
            if ("anonymousUser".equals(username)) {
                request.setAttribute("currentAuthority", (Object)"");
                return;
            }
            StringBuilder builder = new StringBuilder(this.authPath);
            builder.append("auth/menu/module-authority?username=").append(username).append("&moduleCode=").append(moduleCode).append("&clientId=").append(this.clientId);
            Map authorityCode = (Map)this.template.getForObject(builder.toString(), Map.class, new Object[0]);
            request.setAttribute("currentAuthority", authorityCode.get("root"));
            request.setAttribute("elementAuthorities", authorityCode.get("elements"));
            if (log.isDebugEnabled()) {
                log.debug("set currentAuthority ==>" + authorityCode);
            }
        } else {
            request.setAttribute("currentAuthority", (Object)"");
        }
    }

    private void setUrlCurrentAuthority(HttpServletRequest request, String requestPath, String method) {
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            String username = SecurityContextHolder.getContext().getAuthentication().getName();
            if ("anonymousUser".equals(username)) {
                request.setAttribute("currentAuthority", (Object)"");
                return;
            }
            if (StringUtils.isEmpty((Object)method)) {
                method = "GET";
            }
            StringBuilder builder = new StringBuilder(this.authPath);
            builder.append("auth/menu/url-authority?username=").append(username).append("&path=").append(requestPath).append("&clientId=").append(this.clientId).append("&method=").append(method.toUpperCase());
            Map authorityCode = (Map)this.template.getForObject(builder.toString(), Map.class, new Object[0]);
            request.setAttribute("currentAuthority", authorityCode.get("root"));
            request.setAttribute("elementAuthorities", authorityCode.get("elements"));
            if (log.isDebugEnabled()) {
                log.debug("set currentAuthority ==>" + authorityCode);
            }
        } else {
            request.setAttribute("currentAuthority", (Object)"");
        }
    }
}

