/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gscas.annotation;

import cn.gtmap.gtc.starter.gscas.annotation.AuditLog;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;

@Aspect
public class LogAspect
implements ApplicationEventPublisherAware {
    static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private ApplicationEventPublisher publisher;

    @Pointcut(value="@annotation(logActuator)")
    public void LogAspect(AuditLog logActuator) {
    }

    @AfterReturning(returning="response", pointcut="LogAspect(logActuator)")
    public void doAfter(JoinPoint joinPoint, AuditLog logActuator, Object response) {
        if (StringUtils.isEmpty((Object)logActuator.event())) {
            if (log.isDebugEnabled()) {
                log.debug("method: " + joinPoint.getSignature().getName() + " log event is empty!");
            }
            return;
        }
        String[] names = logActuator.names();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Object[] args = joinPoint.getArgs();
        if (null != args && args.length > 0) {
            int j = 0;
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                if (o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof Model || o instanceof ModelAndView || o instanceof Authentication || o instanceof OAuth2Authentication) continue;
                data.put(this.getArgName(names, j), o);
                ++j;
            }
        }
        data.put("current.method", joinPoint.getSignature().getName());
        if (null != response && logActuator.response()) {
            data.put("response", response);
        }
        String principal = SecurityContextHolder.getContext().getAuthentication().getName();
        this.publish(new AuditEvent(principal, logActuator.event(), data));
    }

    private String getArgName(String[] names, int index) {
        if (names != null && names.length > index) {
            return names[index];
        }
        return "arg[" + index + "]";
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getPublisher() {
        return this.publisher;
    }

    protected void publish(AuditEvent event) {
        if (this.getPublisher() != null) {
            this.getPublisher().publishEvent((ApplicationEvent)new AuditApplicationEvent(event));
        }
    }
}

