/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.config;

import javax.annotation.Resource;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@Configuration
public class RabbitMqConfig {
    @Resource
    private RabbitProperties rabbitProperties;

    @Bean
    @Primary
    public ConnectionFactory connectionFactory() throws Exception {
        RabbitProperties.Ssl ssl;
        RabbitConnectionFactoryBean factory = new RabbitConnectionFactoryBean();
        if (this.rabbitProperties.determineHost() != null) {
            factory.setHost(this.rabbitProperties.determineHost());
        }
        factory.setPort(this.rabbitProperties.determinePort());
        if (this.rabbitProperties.determineUsername() != null) {
            factory.setUsername(this.rabbitProperties.determineUsername());
        }
        if (this.rabbitProperties.determinePassword() != null) {
            factory.setPassword(this.rabbitProperties.determinePassword());
        }
        if (this.rabbitProperties.determineVirtualHost() != null) {
            factory.setVirtualHost(this.rabbitProperties.determineVirtualHost());
        }
        if (this.rabbitProperties.getRequestedHeartbeat() != null) {
            factory.setRequestedHeartbeat(this.rabbitProperties.getRequestedHeartbeat().intValue());
        }
        if ((ssl = this.rabbitProperties.getSsl()).isEnabled()) {
            factory.setUseSSL(true);
            if (ssl.getAlgorithm() != null) {
                factory.setSslAlgorithm(ssl.getAlgorithm());
            }
            factory.setKeyStore(ssl.getKeyStore());
            factory.setKeyStorePassphrase(ssl.getKeyStorePassword());
            factory.setTrustStore(ssl.getTrustStore());
            factory.setTrustStorePassphrase(ssl.getTrustStorePassword());
        }
        if (this.rabbitProperties.getConnectionTimeout() != null) {
            factory.setConnectionTimeout(this.rabbitProperties.getConnectionTimeout().intValue());
        }
        factory.afterPropertiesSet();
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory((com.rabbitmq.client.ConnectionFactory)factory.getObject());
        connectionFactory.setAddresses(this.rabbitProperties.determineAddresses());
        connectionFactory.setPublisherConfirms(this.rabbitProperties.isPublisherConfirms());
        connectionFactory.setPublisherReturns(this.rabbitProperties.isPublisherReturns());
        if (this.rabbitProperties.getCache().getChannel().getSize() != null) {
            connectionFactory.setChannelCacheSize(this.rabbitProperties.getCache().getChannel().getSize().intValue());
        }
        if (this.rabbitProperties.getCache().getConnection().getMode() != null) {
            connectionFactory.setCacheMode(this.rabbitProperties.getCache().getConnection().getMode());
        }
        if (this.rabbitProperties.getCache().getConnection().getSize() != null) {
            connectionFactory.setConnectionCacheSize(this.rabbitProperties.getCache().getConnection().getSize().intValue());
        }
        if (this.rabbitProperties.getCache().getChannel().getCheckoutTimeout() != null) {
            connectionFactory.setChannelCheckoutTimeout(this.rabbitProperties.getCache().getChannel().getCheckoutTimeout().longValue());
        }
        return connectionFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitAdmin rabbitAdmin() throws Exception {
        return new RabbitAdmin(this.connectionFactory());
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public RabbitTemplate rabbitTemplate() throws Exception {
        RabbitTemplate template = new RabbitTemplate(this.connectionFactory());
        return template;
    }
}

