/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.config;

import cn.gtmap.gtc.starter.gcas.annotation.FirewalldAspect;
import cn.gtmap.gtc.starter.gcas.filter.xss.XssFilter;
import cn.gtmap.gtc.starter.gcas.property.CorsProperties;
import cn.gtmap.gtc.starter.gcas.property.XssProperties;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={CorsProperties.class, XssProperties.class})
public class FilterConfiguration {
    @Value(value="${filter.xss.sample:true}")
    private String xssSample;

    @Bean(value={"gtmapXssFilter"})
    public FilterRegistrationBean gtmapXssFilter(XssProperties xss) {
        boolean isSample = true;
        if ("false".equals(this.xssSample)) {
            isSample = false;
        }
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new XssFilter(xss.getPath(), xss.isJson(), xss.getExclude(), isSample), new ServletRegistrationBean[0]);
        bean.setOrder(1);
        return bean;
    }

    @Bean(value={"gtmapCorsFilter"})
    @ConditionalOnProperty(name={"filter.cors.path"})
    public FilterRegistrationBean corsFilter(CorsProperties corsProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowedOrigins(new ArrayList(StringUtils.commaDelimitedListToSet((String)corsProperties.getOrigins())));
        config.setAllowCredentials(Boolean.valueOf(corsProperties.isCredentials()));
        config.setAllowedHeaders(new ArrayList(StringUtils.commaDelimitedListToSet((String)corsProperties.getHeaders())));
        config.setAllowedMethods(new ArrayList(StringUtils.commaDelimitedListToSet((String)corsProperties.getMethods().toUpperCase())));
        Set urls = StringUtils.commaDelimitedListToSet((String)corsProperties.getPath());
        for (String s : urls) {
            source.registerCorsConfiguration(s, config);
        }
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(0);
        return bean;
    }

    @Bean
    public FirewalldAspect firewalldAspect() {
        return new FirewalldAspect();
    }
}

