package cn.gtmap.gtc.starter.gcas.util;

import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

import java.util.Locale;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-2-7
 * @description
 */
public class ResourcesMessageUtils {
    private static MessageSource messageSource;

    public ResourcesMessageUtils(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    /**
     * 获取单个国际化翻译值
     */
    public static String get(String msgKey) {
        try {
            return messageSource.getMessage(msgKey, null, LocaleContextHolder.getLocale());
        } catch (Exception e) {
            return msgKey;
        }
    }

    public static String get(String msgKey, Object[] args, Locale locale) {
        try {
            return messageSource.getMessage(msgKey, args, locale);
        } catch (Exception e) {
            return msgKey;
        }
    }
}
