package cn.gtmap.gtc.starter.gcas.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/7/19
 * @description
 */
public class ClientIpUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClientIpUtils.class);

    public static HttpServletRequest getRequest(){
        if (null != RequestContextHolder.getRequestAttributes() && RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes){
            ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            return attributes.getRequest();
        }
        return null;
    }

    public static String getRequestUrl(HttpServletRequest request){
        if (null == request){
            request = getRequest();
        }

        if (null != request) {
            StringBuilder path = new StringBuilder();
            if (request.getServletPath() != null) {
                path.append(request.getServletPath());
                if (request.getPathInfo() != null) {
                    path.append(request.getPathInfo());
                }
            }
            return path.toString();
        }
        return null;
    }

    public static boolean matchUrl(PathMatcher matcher, Collection<String> urls, String requestUrl){
        if (urls != null) {
            for (String url : urls) {
                if (matcher.match(url, requestUrl)){
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean matchUrl(PathMatcher matcher, String[] urls, String requestUrl){
        if (urls != null) {
            for (String url : urls) {
                if (matcher.match(url, requestUrl)){
                    return true;
                }
            }
        }
        return false;
    }

    public static String getRemoteHost(HttpServletRequest request) {
        if (request == null) {
            request = getRequest();
        }
        try{
            if (null != request){
                String ip = request.getHeader("x-forwarded-for");
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getRemoteAddr();
                }

                return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
            }
        }catch (Exception e){
            logger.warn("getRemoteHost", e);
        }
        return "";

    }

    public static String getRequestParam(HttpServletRequest request, String key){
        if (null == request){
            return null;
        }
        Map<String, String[]> parameterMap = request.getParameterMap();
        if (!CollectionUtils.isEmpty(parameterMap)) {
            String[] urls = parameterMap.get(key);
            if (urls != null && urls.length > 0 && org.apache.commons.lang3.StringUtils.isNotBlank(urls[0])){
                return  urls[0];
            }
        }
        return null;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        if (request.getHeader("Accept").indexOf("application/json") > -1
                || (request.getHeader("X-Requested-With") != null && request.getHeader("X-Requested-With").equals(
                "XMLHttpRequest"))) {
            return true;
        }
        return false;
    }
}
