package cn.gtmap.gtc.starter.gcas.property;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/10/24
 * @description
 */
@ConfigurationProperties(prefix = "filter.cors")
public class CorsProperties {
    private String origins = "*";
    private String methods = "*";
    private String headers = "*";
    private String path = "/**";
    private boolean credentials = true;

    public String getOrigins() {
        if (StringUtils.isEmpty(origins)){
            return "*";
        }
        return origins;
    }

    public void setOrigins(String origins) {
        this.origins = origins;
    }

    public String getMethods() {
        if (StringUtils.isEmpty(methods)){
            return "*";
        }
        return methods;
    }

    public void setMethods(String methods) {
        this.methods = methods;
    }

    public String getHeaders() {
        if (StringUtils.isEmpty(headers)){
            return "*";
        }
        return headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public boolean isCredentials() {
        return credentials;
    }

    public void setCredentials(boolean credentials) {
        this.credentials = credentials;
    }

    public String getPath() {
        if (StringUtils.isEmpty(path)){
            return "/**";
        }
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}
