/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.feign.common.exception;

import cn.gtmap.gtc.feign.common.exception.GtFeignException;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class FeignErrorDecoder
implements ErrorDecoder {
    private final GtRetryAfterDecoder retryAfterDecoder = new GtRetryAfterDecoder();

    public Exception decode(String methodKey, Response response) {
        GtFeignException exception = GtFeignException.errorStatus(methodKey, response);
        Date retryAfter = this.retryAfterDecoder.apply((String)this.firstOrNull(response.headers(), "Retry-After"));
        if (retryAfter != null) {
            return new RetryableException(exception.getMessage(), (Throwable)((Object)exception), retryAfter);
        }
        return exception;
    }

    private <T> T firstOrNull(Map<String, Collection<T>> map, String key) {
        if (map.containsKey(key) && !map.get(key).isEmpty()) {
            return map.get(key).iterator().next();
        }
        return null;
    }

    static class GtRetryAfterDecoder {
        static final DateFormat RFC822_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        private final DateFormat rfc822Format;

        GtRetryAfterDecoder() {
            this(RFC822_FORMAT);
        }

        GtRetryAfterDecoder(DateFormat rfc822Format) {
            this.rfc822Format = (DateFormat)Util.checkNotNull((Object)rfc822Format, (String)"rfc822Format", (Object[])new Object[0]);
        }

        protected long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date apply(String retryAfter) {
            if (retryAfter == null) {
                return null;
            }
            if (retryAfter.matches("^[0-9]+$")) {
                long deltaMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter));
                return new Date(this.currentTimeMillis() + deltaMillis);
            }
            DateFormat dateFormat = this.rfc822Format;
            synchronized (dateFormat) {
                try {
                    return this.rfc822Format.parse(retryAfter);
                }
                catch (ParseException ignored) {
                    return null;
                }
            }
        }
    }
}

