package cn.gtmap.gtc.feign.common.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/12/16
 * @description
 */
public class ObjectMapperUtils {
    private static ObjectMapper mapper = null;

    static {
        mapper = new ObjectMapper();
        //反序列化的时候如果多了其他属性,不抛出异常
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        //如果是空对象的时候,不抛异常
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);

        //取消时间的转化格式,默认是时间戳,可以取消,同时需要设置要表现的时间格式
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);

        mapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }

    /**
     * 将JSON字符串转换为对象
     *
     * @param json      JSON字符串
     * @param valueType 对象类型
     *
     * @return 对象
     */
    public static <T> T toObject(String json, Class<T> valueType) {
        if (!StringUtils.isEmpty(json) && null != valueType) {
            try {
                return mapper.readValue(json, valueType);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /**
     * 将对象转换为JSON字符串
     *
     * @param value 对象
     *
     * @return JSOn字符串
     */
    public static String toJson(Object value) {
        try {
            return mapper.writeValueAsString(value);
        } catch (Exception e) {
            // ignore
        }
        return null;
    }

    /**
     * 将JSON字符串转换为对象
     *
     * @param o
     * @param valueType 对象类型
     *
     * @return 对象
     */
    public static <T> T convertValue(Object o, Class<T> valueType) {
        return mapper.convertValue(o, valueType);
    }
}
