package cn.gtmap.gtc.feign.common.exception;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/9/11
 * @description
 */
public class ResponseException extends RuntimeException {

    Map<String, Object> msgMap = new HashMap<>();

    private int code;
    private String message;
    private List<Object> errors;

    public ResponseException(String message) {
        msgMap.put("message", message);
        this.message = conventMsg();
    }

    public ResponseException(int code, String message) {
        msgMap.put("message", message);
        msgMap.put("code", code);
        this.message = conventMsg();
    }

    public ResponseException(String message, int code, Object... errors) {
        msgMap.put("message", message);
        msgMap.put("code", code);
        if (null != errors && errors.length > 0){
            List<Object> es = new ArrayList<>();
            for (Object o : errors) {
                if (null != o) {
                    es.add(o);
                }
            }
            msgMap.put("errors", es);
        }
        this.message = conventMsg();
    }

    private String conventMsg(){
        String msg = ObjectMapperUtils.toJson(msgMap);
        return msg;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public List<Object> getErrors() {
        return errors;
    }

    public void setErrors(List<Object> errors) {
        this.errors = errors;
    }
}
