package cn.gtmap.gtc.feign.common.exception;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import feign.FeignException;
import feign.Response;
import feign.Util;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

import static java.lang.String.format;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/9/11
 * @description
 */
public class GtFeignException extends FeignException {

    private int code;
    private String msgBody;
    private List<Object> errors;

    protected GtFeignException(int status, String message) {
        super(status, message);
    }

    protected GtFeignException(int status, String message, List<Object> errors, String body, int code) {
        super(status, message);
        this.errors = errors;
        this.msgBody = body;
        this.code = code;
    }


    public static GtFeignException errorStatus(String methodKey, Response response) {
        String message = "";
        String body = null;
        List<Object> es = null;
        int code = 0;
        try {
            if (response.body() != null) {
                body = Util.toString(response.body().asReader());
                boolean isResponseException = false;
                Map<String,Object> bodyMap = ObjectMapperUtils.toObject(body, Map.class);
                if (!CollectionUtils.isEmpty(bodyMap)) {
                    Object msg = bodyMap.get("message");
                    if (!StringUtils.isEmpty(msg)){
                        Map<String,Object> msgMap = ObjectMapperUtils.toObject((String) msg, Map.class);
                        if (!CollectionUtils.isEmpty(msgMap)) {
                            isResponseException = true;
                            message += msgMap.get("message");
                            Object codeObj = msgMap.get("code");
                            if (!StringUtils.isEmpty(codeObj) && codeObj instanceof Integer) {
                                code = (int)codeObj;
                            }
                            Object o = msgMap.get("errors");
                            if (null != o && o instanceof List){
                                es = (List)msgMap.get("errors");
                            }
                        }
                    }
                }
                if (!isResponseException){
                    message = format("status %s reading %s", response.status(), methodKey);
                    message += "; content:\n" + body;
                }
            }
        } catch (Exception ignored) { // NOPMD
        }
        return new GtFeignException(response.status(), message, es, body, code);
    }

    public List<Object> getErrors() {
        return errors;
    }

    public void setErrors(List<Object> errors) {
        this.errors = errors;
    }

    public String getMsgBody() {
        return msgBody;
    }

    public void setMsgBody(String msgBody) {
        this.msgBody = msgBody;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
