/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.common.http.result;

import cn.gtmap.gtc.common.http.result.ClassicLinkWrapper;
import cn.gtmap.gtc.common.http.result.ClassicMetaWrapper;
import cn.gtmap.gtc.common.http.result.ClassicResult;
import cn.gtmap.gtc.common.http.result.PageMeta;
import cn.gtmap.gtc.common.http.result.PageMetaWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

public class PageResult<T>
extends ClassicResult<List<T>, ClassicMetaWrapper, ClassicLinkWrapper> {
    public static <R> PageResult<R> from(Page<R> page) {
        return new PageResult(page.getContent(), new ClassicMetaWrapper(new PageMeta(page)));
    }

    public static <R> PageResult<R> from(List<R> list) {
        PageResult pageResult = new PageResult();
        if (list != null) {
            pageResult.setData(list);
            int size = list.size();
            PageMeta pageMeta = size == 0 ? new PageMeta(0, 0, 0, 0L) : new PageMeta(1, size, 1, Long.valueOf(size));
            pageResult.setMeta(new ClassicMetaWrapper(pageMeta));
        }
        return pageResult;
    }

    public PageResult(Collection<T> collection, PageMetaWrapper pageMetaWrapper) {
        if (collection != null) {
            this.data = new ArrayList<T>(collection);
        }
        if (pageMetaWrapper != null) {
            this.meta = pageMetaWrapper instanceof ClassicMetaWrapper ? (ClassicMetaWrapper)pageMetaWrapper : new ClassicMetaWrapper(pageMetaWrapper.getPage());
        }
    }

    public Page<T> toPage() {
        PageMeta pageMeta = ((ClassicMetaWrapper)this.meta).getPage();
        if (pageMeta == null) {
            return null;
        }
        return new PageImpl((List)this.data, pageMeta.toPageable(), Optional.of(pageMeta.getTotalElements()).orElse(0L).longValue());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    public PageResult() {
    }
}

