/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.common.http.result;

import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class PageMeta {
    private Integer number;
    private Integer size;
    private Integer totalPages;
    private Long totalElements;

    public PageMeta(Page<?> page) {
        if (page == null) {
            return;
        }
        this.size = page.getSize();
        this.totalElements = page.getTotalElements();
        this.number = page.getNumber();
        this.totalPages = page.getTotalPages();
    }

    public Pageable toPageable() {
        return new PageRequest(Optional.of(this.number).orElse(1).intValue(), Optional.of(this.size).orElse(10).intValue());
    }

    public Integer getNumber() {
        return this.number;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getTotalPages() {
        return this.totalPages;
    }

    public Long getTotalElements() {
        return this.totalElements;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public void setTotalElements(Long totalElements) {
        this.totalElements = totalElements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageMeta)) {
            return false;
        }
        PageMeta other = (PageMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$number = this.getNumber();
        Integer other$number = other.getNumber();
        if (this$number == null ? other$number != null : !((Object)this$number).equals(other$number)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Integer this$totalPages = this.getTotalPages();
        Integer other$totalPages = other.getTotalPages();
        if (this$totalPages == null ? other$totalPages != null : !((Object)this$totalPages).equals(other$totalPages)) {
            return false;
        }
        Long this$totalElements = this.getTotalElements();
        Long other$totalElements = other.getTotalElements();
        return !(this$totalElements == null ? other$totalElements != null : !((Object)this$totalElements).equals(other$totalElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Integer $totalPages = this.getTotalPages();
        result = result * 59 + ($totalPages == null ? 43 : ((Object)$totalPages).hashCode());
        Long $totalElements = this.getTotalElements();
        result = result * 59 + ($totalElements == null ? 43 : ((Object)$totalElements).hashCode());
        return result;
    }

    public String toString() {
        return "PageMeta(number=" + this.getNumber() + ", size=" + this.getSize() + ", totalPages=" + this.getTotalPages() + ", totalElements=" + this.getTotalElements() + ")";
    }

    public PageMeta() {
    }

    @ConstructorProperties(value={"number", "size", "totalPages", "totalElements"})
    public PageMeta(Integer number, Integer size, Integer totalPages, Long totalElements) {
        this.number = number;
        this.size = size;
        this.totalPages = totalPages;
        this.totalElements = totalElements;
    }
}

